/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.Permission;
import java.security.Permissions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.orchestra.util.Chainer;
import org.ow2.orchestra.util.ClassDataTool;
import org.ow2.orchestra.util.LoggingInvocationHandler;
import org.ow2.orchestra.util.MBeanInvocationHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Misc {
    private static final Logger LOG = Logger.getLogger(Misc.class.getName());
    private static Object formatterLock = new Object();
    public static final Random RANDOM = new Random();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final DateFormat DELAY_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final long DAY = 86400000L;
    private static final AtomicLong SEQUENCE_NUMBER;

    private Misc() {
    }

    public static String getUniqueId(String prefix) {
        return prefix + UUID.randomUUID();
    }

    public static String getHumanReadableId(String prefix) {
        return prefix + Misc.getHumanReadableId();
    }

    public static long getHumanReadableId() {
        return SEQUENCE_NUMBER.getAndIncrement();
    }

    public static int random(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("Pre-condition failed: min(" + min + ") < max(" + max + ")");
        }
        int n = max - min;
        if (n < 0) {
            throw new IllegalArgumentException("Overflow due to big parameters (min: " + min + ", max: " + max + "), sorry!");
        }
        return RANDOM.nextInt(max - min) + min;
    }

    public static String getRandomString(int size) {
        char[] s = new char[size];
        int c = 65;
        int r1 = 0;
        for (int i = 0; i < size; ++i) {
            r1 = (int)(Math.random() * 3.0);
            switch (r1) {
                case 0: {
                    c = 48 + (int)(Math.random() * 10.0);
                    break;
                }
                case 1: {
                    c = 97 + (int)(Math.random() * 26.0);
                    break;
                }
                case 2: {
                    c = 65 + (int)(Math.random() * 26.0);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            s[i] = (char)c;
        }
        return new String(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatDelay(long delay) {
        if (delay == Long.MAX_VALUE) {
            return "INFINITY";
        }
        if (delay == Long.MIN_VALUE) {
            return "-INFINITY";
        }
        if (Math.abs(delay) >= 86400000L) {
            long days = delay / 86400000L;
            return days + " day" + (days > 1L ? "s" : "");
        }
        Object object = formatterLock;
        synchronized (object) {
            return delay < 0L ? "-" + DELAY_FORMATTER.format(new Date(-delay)) : DELAY_FORMATTER.format(new Date(delay));
        }
    }

    public static final String formatDelay(double delay) {
        return Misc.formatDelay((long)delay);
    }

    public static Set<Class<?>> findAllTypes(Class<?> type) {
        Set<Class<?>> superTypes = Misc.findAllSuperTypes(type);
        HashSet result = new HashSet(superTypes);
        for (Class<?> i : superTypes) {
            result.addAll(Misc.findAllInterfaces(i));
        }
        result.addAll(Misc.findAllInterfaces(type));
        return result;
    }

    public static String getGenericFullName(Class<?> clazz) {
        StringBuilder sb = new StringBuilder(clazz.getCanonicalName());
        TypeVariable<Class<?>>[] types = clazz.getTypeParameters();
        if (types.length != 0) {
            sb.append('<');
            for (TypeVariable<Class<?>> type : types) {
                sb.append(type.getName());
                sb.append(',');
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        return new String(sb);
    }

    public static Set<Class<?>> findAllSuperTypes(Class<?> type) {
        HashSet classes = new HashSet();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            classes.add(c);
        }
        return classes;
    }

    public static Set<Class<?>> findAllInterfaces(Class<?> type) {
        Class<?>[] interfaces;
        HashSet classes = new HashSet();
        for (Class<?> i : interfaces = type.getInterfaces()) {
            classes.add(i);
            classes.addAll(Misc.findAllInterfaces(i));
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            classes.addAll(Misc.findAllInterfaces(superClass));
        }
        return classes;
    }

    public static Class<?>[] findMethodClassArgs(Class<?>[] subClasses, Class<?> classToTest, String methodName) throws NoSuchMethodException {
        Set[] classesList = new Set[subClasses.length];
        for (int i = 0; i < classesList.length; ++i) {
            classesList[i] = Misc.findAllTypes(subClasses[i]);
        }
        Method[] methods = classToTest.getDeclaredMethods();
        for (int i = methods.length - 1; i >= 0; --i) {
            Class<?>[] formal;
            if (!methods[i].getName().equals(methodName) || (formal = methods[i].getParameterTypes()).length != subClasses.length || !Misc.checkFormal(formal, classesList)) continue;
            return formal;
        }
        throw new NoSuchMethodException("Can't find formal  parameters for specified arguments: subClasses: " + Misc.componentsToString(subClasses, false) + ", classToTest: " + classToTest + ", methodName: " + methodName);
    }

    public static Class<?>[] findConstructorClassArgs(Class<?>[] subClasses, Class<?> classToTest) throws NoSuchMethodException {
        Set[] classesList = new Set[subClasses.length];
        for (int i = 0; i < classesList.length; ++i) {
            classesList[i] = Misc.findAllTypes(subClasses[i]);
        }
        Constructor<?>[] constructors = classToTest.getDeclaredConstructors();
        for (int i = constructors.length - 1; i >= 0; --i) {
            Class<?>[] formal = constructors[i].getParameterTypes();
            if (formal.length != subClasses.length || !Misc.checkFormal(formal, classesList)) continue;
            return formal;
        }
        throw new NoSuchMethodException("Can't find formal parameters for specified arguments: subClasses: " + Misc.componentsToString(subClasses, false) + ", classToTest: " + classToTest);
    }

    private static boolean checkFormal(Class<?>[] formal, Set<Class<?>>[] types) {
        for (int i = 0; i < formal.length; ++i) {
            Iterator<Class<?>> iterator = types[i].iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Class<?> type = iterator.next();
                if (!type.equals(formal[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static String identityToString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "#" + System.identityHashCode(o);
    }

    public static String componentsToString(Object[] args, boolean deepToString) {
        if (args == null) {
            return "null";
        }
        Class<?> componentType = args.getClass().getComponentType();
        StringBuilder string = new StringBuilder(componentType.getName());
        string.append("[");
        int length = args.length;
        if (length != 0) {
            int max = length - 1;
            for (int i = 0; i < max; ++i) {
                if (args[i] == null) {
                    string.append("null");
                } else if (args[i].getClass().isArray()) {
                    componentType = args[i].getClass().getComponentType();
                    if (componentType.isPrimitive()) {
                        string.append(Misc.primitiveComponentsToString(args[i]));
                    } else {
                        string.append(Misc.componentsToString((Object[])args[i], deepToString));
                    }
                } else {
                    string.append(deepToString ? Misc.deepToString(args[i]) : args[i].toString());
                }
                string.append("; ");
            }
            if (args[max] == null) {
                string.append("null");
            } else if (args[max].getClass().isArray()) {
                componentType = args[max].getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    string.append(Misc.primitiveComponentsToString(args[max]));
                } else {
                    string.append(Misc.componentsToString((Object[])args[max], deepToString));
                }
            } else {
                string.append(deepToString ? Misc.deepToString(args[max]) : args[max].toString());
            }
        }
        string.append("]");
        return new String(string);
    }

    public static String primitiveComponentsToString(Object array) {
        if (array == null) {
            return "null";
        }
        Class<?> c = array.getClass();
        if (!c.isArray() || !c.getComponentType().isPrimitive()) {
            throw new IllegalArgumentException("array must be an array of primitive component");
        }
        StringBuilder string = new StringBuilder(c.getComponentType().getName());
        string.append("[");
        int length = Array.getLength(array);
        if (length != 0) {
            int max = length - 1;
            for (int i = 0; i < max; ++i) {
                string.append(Array.get(array, i));
                string.append("; ");
            }
            string.append(Array.get(array, max));
        }
        string.append("]");
        return new String(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = Misc.getAllContentFrom(in);
        }
        catch (Throwable throwable) {
            Misc.close(in);
            throw throwable;
        }
        Misc.close(in);
        return byArray;
    }

    public static Map<String, byte[]> getDirContentFrom(File dir) throws IOException {
        String[] fileArray;
        Misc.checkArgsNotNull(dir);
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
        if (!dir.exists()) {
            throw new IllegalArgumentException("Given file: " + dir.getAbsolutePath() + " does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Given file: " + dir.getAbsolutePath() + " is not a directory!");
        }
        for (String element : fileArray = dir.list()) {
            String fileName = dir.getAbsolutePath() + File.separator + element;
            File file = new File(fileName);
            if (file.isDirectory()) {
                Misc.getDirContentFrom(file, result, element);
                continue;
            }
            result.put(element, Misc.getAllContentFrom(file));
        }
        return result;
    }

    private static void getDirContentFrom(File currDir, Map<String, byte[]> result, String prefix) throws IOException {
        String[] fileArray;
        for (String element : fileArray = currDir.list()) {
            String fileName = currDir.getAbsolutePath() + File.separator + element;
            File file = new File(fileName);
            if (file.isDirectory()) {
                Misc.getDirContentFrom(file, result, prefix + File.separator + element);
                continue;
            }
            result.put(prefix + File.separator + element, Misc.getAllContentFrom(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputSource source) throws IOException {
        InputStream in = null;
        try {
            in = source.getByteStream();
            byte[] byArray = Misc.getAllContentFrom(in);
            return byArray;
        }
        finally {
            Misc.close(in);
        }
    }

    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        return Misc.getAllContentFrom(in);
    }

    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        int c;
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while ((c = bis.read()) != -1) {
            result.write(c);
        }
        return result.toByteArray();
    }

    public static byte[] getAllContentFrom(Reader in) throws IOException {
        int c;
        BufferedReader bis = new BufferedReader(in);
        StringBuilder result = new StringBuilder();
        char[] buf = new char[1024];
        while ((c = bis.read(buf)) != -1) {
            result.append(buf, 0, c);
        }
        return result.toString().getBytes();
    }

    public static Exception close(Closeable closeable) {
        return Misc.reflectClose(closeable);
    }

    public static Exception close(XMLEncoder encoder) {
        return Misc.reflectClose(encoder);
    }

    public static Exception close(XMLDecoder decoder) {
        return Misc.reflectClose(decoder);
    }

    public static Exception reflectClose(Object o) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod("close", new Class[0]);
            m.setAccessible(true);
            m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Exception thrown during close() on: ");
            sb.append(o.toString());
            sb.append(LINE_SEPARATOR);
            sb.append("Exception message is: ");
            sb.append(e.getMessage());
            sb.append(LINE_SEPARATOR);
            sb.append(Misc.getStackTraceFrom(e));
            LOG.warning(sb.toString());
            return e;
        }
        return null;
    }

    public static int getPermissionsSize(Permissions permissions) {
        int size = 0;
        Enumeration<Permission> p = permissions.elements();
        while (p.hasMoreElements()) {
            ++size;
        }
        return size;
    }

    public static <T> T getMBeanProxy(Class<T> mbeanInterface, String jmxServiceUrl, String jmxObjectName) throws IOException, MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), new Class[]{mbeanInterface}, (InvocationHandler)new MBeanInvocationHandler(jmxServiceUrl, jmxObjectName));
    }

    public static <T> T getChainOf(List<T> elements) {
        Misc.checkArgsNotNull(elements);
        Chainer<T> chain = new Chainer<T>();
        HashSet classes = new HashSet();
        Set<Class<?>> initial = Misc.findAllInterfaces(elements.get(0).getClass());
        classes.addAll(initial);
        for (T element : elements) {
            chain.add(element);
            Set<Class<?>> interfaces = Misc.findAllInterfaces(element.getClass());
            classes.retainAll(interfaces);
        }
        if (classes.size() == 0) {
            throw new IllegalArgumentException("Can't find a common interface between classes of elements: " + elements);
        }
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), classes.toArray(new Class[classes.size()]), chain);
    }

    public static <T> T getLoggerProxyFor(T target, Logger logger) {
        Set<Class<?>> classes = Misc.findAllInterfaces(target.getClass());
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), classes.toArray(new Class[classes.size()]), new LoggingInvocationHandler<T>(target, logger));
    }

    public static NullCheckResult findNull(Object ... params) {
        if (params == null) {
            BitSet bitSet = new BitSet(1);
            bitSet.set(0);
            return new NullCheckResult(bitSet, 1);
        }
        BitSet bitSet = new BitSet(params.length);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                bitSet.set(i, true);
                continue;
            }
            bitSet.set(i, false);
        }
        return new NullCheckResult(bitSet, params.length);
    }

    public static void checkArgsNotNull(Object ... params) {
        Misc.checkArgsNotNull(1, params);
    }

    public static void checkArgsNotNull(int offset, Object ... params) {
        NullCheckResult result = Misc.findNull(params);
        if (result.hasNull()) {
            StackTraceElement callerSTE = Misc.getCaller(offset + 1);
            String className = callerSTE.getClassName();
            String methodName = callerSTE.getMethodName();
            StringBuilder sb = new StringBuilder("Some parameters are null in " + className + "." + methodName + "(): ");
            for (int i = 0; i < result.getSize(); ++i) {
                if (result.isNull(i)) {
                    sb.append("null");
                } else {
                    sb.append(params[i].getClass().getName());
                }
                if (i >= result.getSize() - 1) continue;
                sb.append(", ");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static StackTraceElement getCaller(int offset) {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        StackTraceElement callerSTE = null;
        for (int i = 0; i < stes.length - offset - 1; ++i) {
            if (!stes[i].getClassName().equals(Misc.class.getName()) || !stes[i].getMethodName().equals("getCaller")) continue;
            callerSTE = stes[i + 1 + offset];
            break;
        }
        Misc.badStateIfNull(callerSTE, "Ouch! Can't get the stack trace back to the caller of this method!");
        return callerSTE;
    }

    public static List<String> getStringFrom(NullCheckResult nullCheckResult, String ... names) {
        int n = names.length;
        if (nullCheckResult.getSize() != n) {
            throw new IllegalArgumentException("Number of string names is different from the arguments used to get the nullCheckResult: " + n + " != " + nullCheckResult.getSize());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!nullCheckResult.hasNull()) {
            return list;
        }
        for (int i = 0; i < n; ++i) {
            if (!nullCheckResult.isNull(i)) continue;
            list.add(names[i]);
        }
        return list;
    }

    public static void badStateIfNull(Object valueToCheck, String msg) {
        Misc.badStateIfTrue(valueToCheck == null, msg);
    }

    public static void badStateIfNotNull(Object valueToCheck, String msg) {
        Misc.badStateIfTrue(valueToCheck != null, msg);
    }

    public static void badStateIfTrue(boolean valueToCheck, String msg) {
        if (valueToCheck) {
            throw new IllegalStateException(msg);
        }
    }

    public static void badStateIfFalse(boolean valueToCheck, String msg) {
        Misc.badStateIfTrue(!valueToCheck, msg);
    }

    public static void badStateIfEquals(Object a, Object b, String msg) {
        Misc.badStateIfTrue(a.equals(b), msg);
    }

    public static void dynamicLog(int offset, Level level, String msg, Object ... args) {
        StackTraceElement callerSTE = Misc.getCaller(offset);
        String className = callerSTE.getClassName();
        String methodName = callerSTE.getMethodName();
        Logger logger = Logger.getLogger(className);
        if (logger.isLoggable(level)) {
            logger.log(Misc.createLogRecord(logger, level, className, methodName, msg, args));
        }
    }

    public static void slowLog(Level level, String msg, Object ... args) {
        Misc.dynamicLog(2, level, msg, args);
    }

    public static LogRecord createLogRecord(Logger logger, Level level, String className, String methodName, String msg, Object ... args) {
        try {
            LogRecord record = new LogRecord(level, args != null && args.length != 0 ? String.format(msg, args) : msg);
            record.setSourceClassName(className);
            record.setSourceMethodName(methodName);
            record.setLoggerName(logger.getName());
            return record;
        }
        catch (IllegalFormatException ife) {
            StringBuilder sb = new StringBuilder("An exception was thrown while logging on logger: ");
            sb.append(logger);
            sb.append(" at level: ");
            sb.append(level);
            sb.append(" by: ");
            sb.append(className);
            sb.append('.');
            sb.append(methodName);
            sb.append("()");
            sb.append(" message: \"");
            sb.append(msg);
            sb.append("\" arguments: ");
            sb.append(Misc.componentsToString(args, false));
            sb.append(LINE_SEPARATOR);
            sb.append("Exception is: ");
            sb.append(Misc.getStackTraceFrom(ife));
            return Misc.createLogRecord(LOG, Level.WARNING, Misc.class.getName(), "createLogRecord", sb.toString(), new Object[0]);
        }
    }

    public static void fastDynamicLog(int offset, Logger logger, Level level, String msg, Object ... args) {
        if (logger.isLoggable(level)) {
            StackTraceElement callerSTE = Misc.getCaller(offset);
            String className = callerSTE.getClassName();
            String methodName = callerSTE.getMethodName();
            logger.log(Misc.createLogRecord(logger, level, className, methodName, msg, args));
        }
    }

    public static void fastDynamicLog(Logger logger, Level level, String msg, Object ... args) {
        if (logger.isLoggable(level)) {
            StackTraceElement callerSTE = Misc.getCaller(2);
            String className = callerSTE.getClassName();
            String methodName = callerSTE.getMethodName();
            logger.log(Misc.createLogRecord(logger, level, className, methodName, msg, args));
        }
    }

    public static void warnIfNull(Level level, Object valueToCheck, String variableName) {
        if (valueToCheck == null) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is null!";
            Misc.dynamicLog(1, level, msg, new Object[0]);
        }
    }

    public static void warnIfNotNull(Level level, Object valueToCheck, String variableName) {
        if (valueToCheck != null) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is not null!";
            Misc.dynamicLog(1, level, msg, new Object[0]);
        }
    }

    public static void warnIfTrue(Level level, boolean valueToCheck, String variableName) {
        if (valueToCheck) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is true!";
            Misc.dynamicLog(1, level, msg, new Object[0]);
        }
    }

    public static void warnIfFalse(Level level, boolean valueToCheck, String variableName) {
        if (!valueToCheck) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is false!";
            Misc.dynamicLog(1, level, msg, new Object[0]);
        }
    }

    public static void warnIfEquals(Level level, Object a, Object b) {
        if (a.equals(b)) {
            Misc.dynamicLog(1, level, "Warning: equals objects: " + LINE_SEPARATOR + Misc.details(a, b), new Object[0]);
        }
    }

    private static String details(Object a, Object b) {
        return "a.toString(): " + a.toString() + LINE_SEPARATOR + "b.toString(): " + b.toString() + LINE_SEPARATOR + "a.idendityToString(): " + Misc.identityToString(a) + LINE_SEPARATOR + "b.identityToString(): " + Misc.identityToString(b);
    }

    public static void warnIfNotEquals(Level level, Object a, Object b) {
        if (!a.equals(b)) {
            Misc.dynamicLog(1, level, "Warning: non-equals objects: " + LINE_SEPARATOR + Misc.details(a, b), new Object[0]);
        }
    }

    public static String getCurrentThreadStackTrace() {
        return Misc.getStackTraceFrom(Thread.currentThread().getStackTrace()).toString();
    }

    public static String getStackTraceFrom(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static StringBuilder getStackTraceFrom(StackTraceElement[] stes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement element : stes) {
            stringBuilder.append("  at ");
            stringBuilder.append(element.toString());
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder;
    }

    public static String deepToString(Object o) {
        return Misc.recursiveDeepToString(o, new HashMap<Object, String>());
    }

    private static String recursiveDeepToString(Object o, Map<Object, String> cache) {
        String result = cache.get(o);
        String id = "@" + Integer.toHexString(System.identityHashCode(o));
        if (result != null) {
            return result;
        }
        if (o == null) {
            result = "null";
        } else {
            cache.put(o, id);
            Class<?> clazz = o.getClass();
            Package pack = clazz.getPackage();
            if (clazz.isPrimitive() || pack != null && pack.getName().startsWith("java.") || clazz.isEnum()) {
                result = o.toString();
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                result = componentType.isPrimitive() ? Misc.primitiveComponentsToString(o) : Misc.componentsToString((Object[])o, true);
            } else {
                Field[] fields;
                StringBuilder sb = new StringBuilder(clazz.getName());
                sb.append('(');
                sb.append(id);
                sb.append(')');
                sb.append("[");
                for (Field field : fields = clazz.getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        sb.append(field.getName());
                        sb.append(": ");
                        Object f = field.get(o);
                        String v = cache.get(f);
                        sb.append(id.equals(v) ? id : Misc.recursiveDeepToString(f, cache));
                    }
                    catch (IllegalAccessException e) {
                        LOG.warning("An exception occured during information fetching on field: " + field + LINE_SEPARATOR + "Stack trace is: " + Misc.getStackTraceFrom(e) + "Fallbacking to non-intrusive algorithm for toString().");
                        sb.append("(*");
                        sb.append(field.toGenericString());
                        sb.append("*)");
                    }
                    sb.append(", ");
                }
                if (fields.length != 0) {
                    sb.delete(sb.length() - 2, sb.length());
                }
                sb.append("]");
                result = new String(sb);
            }
        }
        cache.put(o, result);
        return result;
    }

    public static boolean deleteDir(File dir) {
        String[] fileArray;
        Misc.checkArgsNotNull(dir);
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Given file: " + dir.getAbsolutePath() + " is not a directory!");
        }
        for (String element : fileArray = dir.list()) {
            String fileName = dir.getAbsolutePath() + File.separator + element;
            File file = new File(fileName);
            if (!(file.isDirectory() ? !Misc.deleteDir(file) : !file.delete())) continue;
            return false;
        }
        return dir.delete();
    }

    public static void unreachableStatement() {
        Misc.unreachableStatement("This statement should never be reached!");
    }

    public static void unreachableStatement(String reason) {
        throw new IllegalStateException(reason);
    }

    public static <E extends Enum<E>> E stringToEnum(Class<E> c, String s) {
        EnumSet<Enum> set = EnumSet.allOf(c);
        for (Enum e : set) {
            if (!e.toString().equals(s)) continue;
            return (E)e;
        }
        throw new IllegalArgumentException("Unknown enum string for " + c.getName() + ": " + s + ". Possible values are: " + set.toString());
    }

    public static byte[] serialize(Serializable object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(object);
        out.flush();
        out.close();
        return bos.toByteArray();
    }

    public static Serializable deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Serializable newObject = (Serializable)ois.readObject();
        ois.close();
        return newObject;
    }

    public static <T extends Serializable> Exception checkReallySerializable(T object) {
        try {
            byte[] buf = Misc.serialize(object);
            Misc.deserialize(buf);
            return null;
        }
        catch (Exception t) {
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String s, File f) throws IOException {
        Misc.checkArgsNotNull(s, f);
        FileWriter writer = new FileWriter(f);
        try {
            writer.write(s);
            writer.flush();
        }
        finally {
            Misc.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] fileContent, File file) throws IOException {
        Misc.checkArgsNotNull(file, fileContent);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
        catch (Throwable throwable) {
            Misc.close(os);
            throw throwable;
        }
        Misc.close(os);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File tmpDir = null;
        int retryNumber = 10;
        int j = 0;
        boolean succeded = false;
        do {
            try {
                tmpDir = File.createTempFile(prefix, suffix, directory);
                succeded = true;
            }
            catch (IOException e) {
                if (j == 10) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ++j;
            }
        } while (!succeded);
        return tmpDir;
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return Misc.generateJar(Misc.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            throw new IOException("No classes available");
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName() + ".class", ClassDataTool.getClassData(clazz));
        }
        return resources;
    }

    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            throw new IOException("No Resources available");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream(new BufferedOutputStream(baos));
        for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
            out.putNextEntry(new JarEntry(resource.getKey()));
            out.write(resource.getValue());
        }
        out.flush();
        Misc.close(out);
        return baos.toByteArray();
    }

    public static Map<String, byte[]> getResourcesFromZip(byte[] zipContent) throws IOException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(zipContent);
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry zipEntry = null;
        while ((zipEntry = zis.getNextEntry()) != null) {
            int c;
            if (zipEntry.isDirectory()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            while ((c = zis.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.flush();
            resources.put(zipEntry.getName(), baos.toByteArray());
            Misc.close(baos);
        }
        zis.close();
        ((InputStream)in).close();
        return resources;
    }

    public static <T> T lookup(String name, Properties environment) throws NamingException {
        InitialContext initialContext = null;
        initialContext = environment != null ? new InitialContext(environment) : new InitialContext();
        return (T)initialContext.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prefixAllLines(String message, String prefix) {
        Misc.checkArgsNotNull(message, prefix);
        if (message.length() == 0) {
            return prefix;
        }
        BufferedReader reader = new BufferedReader(new StringReader(message));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (builder.length() != 0) {
                    builder.append(LINE_SEPARATOR);
                }
                builder.append(prefix).append(line);
            }
        }
        catch (IOException e) {
            Misc.unreachableStatement("Ouch! How can it be that a StringReader throws an IOException?");
        }
        finally {
            Misc.close(reader);
        }
        return builder.toString();
    }

    static {
        DELAY_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT"));
        SEQUENCE_NUMBER = new AtomicLong(0L);
    }

    public static class NullCheckResult {
        private final int size;
        private final BitSet bitSet;

        NullCheckResult(BitSet bitSet, int size) {
            this.bitSet = bitSet;
            this.size = size;
        }

        public boolean hasNull() {
            return this.bitSet.cardinality() != 0;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isNull(int i) {
            return this.bitSet.get(i);
        }
    }
}

