/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class CountForEachTest
extends BpelTestCase {
    public CountForEachTest() {
        super("http://orchestra.ow2.org/foreach", "countForeach", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testCountForEach() {
        this.deploy();
        this.launch(1, 4);
        this.undeploy();
    }

    public void testCountForEachNegative() {
        this.deploy();
        BpelFaultException e = this.launchInvalid(-1, 1);
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testCountForEachStartNotOne() {
        this.deploy();
        this.launch(3, 4);
        this.undeploy();
    }

    public void testEqualsCountForEach() {
        this.deploy();
        this.launch(3, 3);
        this.undeploy();
    }

    public void testGreaterCountForEach() {
        this.deploy();
        this.launch(6, 4);
        this.undeploy();
    }

    public long launch(int start, int stop) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        QName portTypeQName = new QName(this.getProcessNamespace(), "foreachPT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        long endTime = System.currentTimeMillis();
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        String[] counts = reply.getPartValue("count").getTextContent().split(",");
        Assert.assertTrue((boolean)counts[0].equals("s"));
        int expectedSize = stop - start + 1;
        if (expectedSize < 0) {
            expectedSize = 0;
        }
        Assert.assertEquals((int)(++expectedSize), (int)counts.length);
        for (int i = 1; i < expectedSize; ++i) {
            Assert.assertEquals((int)(start + i - 1), (int)Integer.parseInt(counts[i]));
        }
        this.deleteInstance(callResult);
        return endTime;
    }

    public BpelFaultException launchInvalid(int start, int stop) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        QName portTypeQName = new QName(this.getProcessNamespace(), "foreachPT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

