/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.def.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationSetDefinition;
import org.ow2.orchestra.facade.def.OnAlarmDefinition;
import org.ow2.orchestra.facade.def.OnEventDefinition;
import org.ow2.orchestra.facade.def.PartnerLinkDefinition;
import org.ow2.orchestra.facade.def.ScopeActivityDefinition;
import org.ow2.orchestra.facade.def.VariableDefinition;
import org.ow2.orchestra.facade.def.impl.BpelActivityWithSingleChildDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="scope")
public class ScopeActivityDefinitionImpl
extends BpelActivityWithSingleChildDefinitionImpl
implements ScopeActivityDefinition {
    private static final long serialVersionUID = 6093998771288082618L;
    @XmlElement
    protected boolean exitOnStandardFault;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    protected List<VariableDefinition> variables;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    protected List<CorrelationSetDefinition> correlationSets;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    protected List<PartnerLinkDefinition> partnerLinks;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    protected List<OnEventDefinition> onEvents;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    protected List<OnAlarmDefinition> onAlarms;
    @XmlElement
    protected List<String> messageExchanges;
    @XmlElement
    protected List<ActivityDefinitionUUID> faultHandlerUUIDs = null;
    @XmlElement
    protected ActivityDefinitionUUID terminationHandlerUUID = null;
    @XmlElement
    protected ActivityDefinitionUUID compensationHandlerUUID = null;

    protected ScopeActivityDefinitionImpl() {
    }

    public ScopeActivityDefinitionImpl(ScopeActivityDefinition record) {
        super(record);
        this.exitOnStandardFault = record.getExitOnStandardFault();
        this.variables = CopyUtil.copyList(record.getVariables());
        this.correlationSets = CopyUtil.copyList(record.getCorrelationSets());
        this.partnerLinks = CopyUtil.copyList(record.getPartnerLinks());
        this.onAlarms = CopyUtil.copyList(record.getOnAlarmEventHandlers());
        this.onEvents = CopyUtil.copyList(record.getOnEventEventHandlers());
        this.messageExchanges = new ArrayList<String>();
        for (String messageExchange : record.getMessageExchanges()) {
            this.messageExchanges.add(messageExchange);
        }
        this.faultHandlerUUIDs = new ArrayList<ActivityDefinitionUUID>();
        for (ActivityDefinitionUUID faultHandlerUUID : record.getFaultHandlerUUIDs()) {
            this.faultHandlerUUIDs.add(new ActivityDefinitionUUID(faultHandlerUUID));
        }
        this.terminationHandlerUUID = new ActivityDefinitionUUID(record.getTerminationHandlerDefinitionUUID());
        this.compensationHandlerUUID = new ActivityDefinitionUUID(record.getCompensationHandlerDefinitionUUID());
    }

    @Override
    public ActivityType getType() {
        return ActivityType.SCOPE;
    }

    @Override
    public boolean getExitOnStandardFault() {
        return this.exitOnStandardFault;
    }

    @Override
    public List<VariableDefinition> getVariables() {
        return this.variables;
    }

    @Override
    public List<CorrelationSetDefinition> getCorrelationSets() {
        return this.correlationSets;
    }

    @Override
    public List<PartnerLinkDefinition> getPartnerLinks() {
        return this.partnerLinks;
    }

    @Override
    public List<String> getMessageExchanges() {
        return this.messageExchanges;
    }

    @Override
    public List<ActivityDefinitionUUID> getFaultHandlerUUIDs() {
        return this.faultHandlerUUIDs;
    }

    @Override
    public ActivityDefinitionUUID getTerminationHandlerDefinitionUUID() {
        return this.terminationHandlerUUID;
    }

    @Override
    public ActivityDefinitionUUID getCompensationHandlerDefinitionUUID() {
        return this.compensationHandlerUUID;
    }

    public List<OnAlarmDefinition> getOnAlarmEventHandlers() {
        return this.onAlarms;
    }

    public List<OnEventDefinition> getOnEventEventHandlers() {
        return this.onEvents;
    }
}

