/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.impl;

import javax.xml.bind.annotation.XmlElement;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.Misc;

public abstract class ActivityInstanceImpl
extends RuntimeRecordImpl
implements ActivityInstance {
    private static final long serialVersionUID = -8839590974299983697L;
    @XmlElement
    protected ActivityInstanceUUID uuid;
    @XmlElement
    protected ActivityDefinitionUUID definitionUUID;
    protected BpelFaultException lastException;

    protected ActivityInstanceImpl() {
    }

    public ActivityInstanceImpl(ActivityInstance record) {
        super(record);
        this.uuid = record.getUUID();
        this.definitionUUID = record.getDefinitionUUID();
        this.lastException = record.getLastException() != null ? record.getLastException().copy() : null;
    }

    public String toString() {
        String st = this.getClass().getName() + "[uuid: " + this.getUUID() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + "]" + Misc.LINE_SEPARATOR;
        return st;
    }

    public ActivityInstanceUUID getUUID() {
        return this.uuid;
    }

    public ActivityDefinitionUUID getDefinitionUUID() {
        return this.definitionUUID;
    }

    public BpelFaultException getLastException() {
        return this.lastException;
    }

    public final int hashCode() {
        return this.uuid.hashCode() + super.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.uuid.equals(((ActivityInstanceImpl)obj).getUUID());
    }
}

