/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.rest.ByteArrayWrapper;
import org.ow2.orchestra.facade.rest.InterfaceWrapper;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/management/")
public interface JaxRSManagementAPI {
    @PUT
    @Path(value="/process?type=deployment")
    public InterfaceWrapper<ProcessDefinition> deploy(Deployment var1);

    @PUT
    @Path(value="/process/{processUUID}/webServices")
    public void deployWebServices(@PathParam(value="processUUID") ProcessDefinitionUUID var1);

    @DELETE
    @Path(value="/process/{processUUID}/webServices")
    public void undeployWebServices(@PathParam(value="processUUID") ProcessDefinitionUUID var1);

    @POST
    @Path(value="/process/undeploy")
    public boolean undeploy(@QueryParam(value="namespace") String var1, @QueryParam(value="name") String var2);

    @POST
    @Path(value="/process/{processUUID}/undeploy")
    public boolean undeploy(@PathParam(value="processUUID") ProcessDefinitionUUID var1);

    @POST
    @Path(value="/process/{processUUID}/remove")
    public boolean remove(@PathParam(value="processUUID") ProcessDefinitionUUID var1);

    @POST
    @Path(value="/process/{processUUID}/activate")
    public boolean activate(@PathParam(value="processUUID") ProcessDefinitionUUID var1) throws ProcessNotFoundException;

    @POST
    @Path(value="/process/{processUUID}/retire")
    public boolean retire(@PathParam(value="processUUID") ProcessDefinitionUUID var1) throws ProcessNotFoundException;

    @POST
    @Path(value="/process/{processUUID}/refresh")
    public void refreshProcess(@PathParam(value="processUUID") ProcessDefinitionUUID var1);

    @PUT
    @Path(value="/process?type=bar")
    public InterfaceWrapper<ProcessDefinition> deployBar(ByteArrayWrapper var1);

    @POST
    @Path(value="/init")
    public void initialize();

    @POST
    @Path(value="/supportedExtensions")
    public boolean isExtensionSupported(@QueryParam(value="namespace") String var1);
}

