/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;
import org.ow2.orchestra.util.Misc;

public class InitAction
implements ClientAction {
    private final Options options = ClientOptions.createInitOptions();

    public static void init(String jmxServiceUrl, String jmxObjectName) {
        try {
            RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
            remoteDeployer.initialize();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception during initialization", e);
        }
    }

    protected static void init(CommandLine line) {
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        InitAction.init(jmxServiceUrl, jmxObjectName);
        System.out.println("Orchestra is started and initialized");
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        InitAction.init(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To initialize Orchestra Engine (redeploy WS after a crash)";
    }
}

