/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.Arrays;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class ParallelForEachTest
extends BpelTestCase {
    public ParallelForEachTest() {
        super("http://orchestra.ow2.org/parallelForeach", "parallelForeach", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testParallelForEach() {
        this.deploy();
        this.launch(1, 3, false);
        this.undeploy();
    }

    public void testCountParallelForEach() {
        this.deploy();
        this.launch(1, 4, true);
        this.undeploy();
    }

    public void testCountParallelForEachNegative() {
        this.deploy();
        BpelFaultException e = this.launchInvalid(-2, 1, true);
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testCountParallelForEachStartNotOne() {
        this.deploy();
        this.launch(3, 4, true);
        this.undeploy();
    }

    public void testEqualsCountParallelForEach() {
        this.deploy();
        this.launch(3, 3, true);
        this.undeploy();
    }

    public void testGreaterCountParallelForEach() {
        this.deploy();
        this.launch(6, 4, true);
        this.undeploy();
    }

    public long launch(int start, int stop, boolean verifyCount) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
            MessageVariable reply = callResults[i].getMessageCarrier().getMessage();
            Assert.assertEquals((int)(i + 1), (int)Integer.parseInt(reply.getPartValue("id").getTextContent()));
            Assert.assertEquals((int)(i + 1), (int)Integer.parseInt(reply.getPartValue("time").getTextContent()));
        }
        long endTime = System.currentTimeMillis();
        if (verifyCount) {
            int i2;
            MessageVariable reply = callResult.getMessageCarrier().getMessage();
            String[] counts = reply.getPartValue("count").getTextContent().split(",");
            Assert.assertTrue((boolean)counts[0].equals("s"));
            int[] countValues = new int[callCount];
            Assert.assertEquals((int)(callCount + 1), (int)counts.length);
            for (i2 = 1; i2 < counts.length; ++i2) {
                countValues[i2 - 1] = Integer.parseInt(counts[i2]);
            }
            Arrays.sort(countValues);
            for (i2 = 0; i2 < callCount; ++i2) {
                Assert.assertEquals((int)(start + i2), (int)countValues[i2]);
            }
        }
        this.deleteInstance(callResult);
        return endTime;
    }

    public BpelFaultException launchInvalid(int start, int stop, boolean verifyCount) {
        int i;
        int callCount = Math.max(0, stop - start + 1);
        BpelTestCase.CallResult[] callResults = new BpelTestCase.CallResult[callCount];
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        operationName = "initiate";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < callCount; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(callCount - i - 1)));
            callResults[i] = this.call(parts, portTypeQName, operationName);
        }
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

