/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.querier;

import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.AccessorUtil;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;

public class GetProcessResourceRemoteTest
extends RemoteTestCase {
    private static final String PROCESS_NAME = "apitest1";
    private static final String NAME_SPACE = "http://orchestra.ow2.org/tests/querier/";

    public ProcessDefinition deploy() throws IOException, OrchestraException {
        return this.deployBar("apitest1.bpel", "apitest.wsdl");
    }

    public void undeploy() {
        this.undeploy(new QName(NAME_SPACE, PROCESS_NAME));
    }

    public void testGetProcessResource() throws Exception {
        QueryDefinitionAPI queryDefinitionAPI = AccessorUtil.getQueryDefinitionAPI((String)this.jmxServiceUrl, (String)this.jmxObjectName);
        ProcessDefinition processDefinition = this.deploy();
        Assert.assertEquals((int)2, (int)processDefinition.getProcessResourceNames().size());
        this.checkResource(queryDefinitionAPI, processDefinition, "apitest1.bpel");
        this.checkResource(queryDefinitionAPI, processDefinition, "apitest.wsdl");
        this.undeploy();
    }

    private void checkResource(QueryDefinitionAPI queryDefinitionAPI, ProcessDefinition processDefinition, String resourceName) throws ProcessNotFoundException, IOException {
        Assert.assertTrue((String)("resource " + resourceName + " not found !"), (boolean)processDefinition.getProcessResourceNames().contains(resourceName));
        byte[] actualContent = queryDefinitionAPI.getProcessResource(processDefinition.getUUID(), resourceName);
        byte[] expectedContent = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(resourceName));
        Assert.assertEquals((String)new String(expectedContent), (String)new String(actualContent));
    }
}

