/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.receive;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReceiveTest
extends BpelTestCase {
    public ReceiveTest() {
        super("http://example.com/receive", "receive");
    }

    public void testReceive() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testReceiveScope() {
        this.deploy(((Object)((Object)this)).getClass().getResource("receiveInScope.bpel"));
        this.launch();
        this.undeploy();
    }

    public void testReceiveVariable() {
        this.deploy(((Object)((Object)this)).getClass().getResource("receiveVariable.bpel"));
        this.launch();
        this.undeploy();
    }

    public void testReceiveVariableScope() {
        this.deploy(((Object)((Object)this)).getClass().getResource("receiveVariableInScope.bpel"));
        this.launch();
        this.undeploy();
    }

    public long launch() {
        URL bigProduct = ((Object)((Object)this)).getClass().getResource("bigProduct.xml");
        this.assertExists(bigProduct);
        URL stElement = ((Object)((Object)this)).getClass().getResource("stElement.xml");
        this.assertExists(stElement);
        URL intElement = ((Object)((Object)this)).getClass().getResource("intElement.xml");
        this.assertExists(intElement);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("product", XmlUtil.getDocumentFromURL((URL)bigProduct).getDocumentElement());
        parts.put("stElement", XmlUtil.getDocumentFromURL((URL)stElement).getDocumentElement());
        parts.put("stType", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        parts.put("intElement", XmlUtil.getDocumentFromURL((URL)intElement).getDocumentElement());
        parts.put("intType", BpelXmlUtil.createElementWithContent((String)"5"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(result.getVariables());
                Assert.assertEquals((int)5, (int)result.getVariables().size());
                ReceiveTest.this.assertProduct(ReceiveTest.this.getVariableValue(result, "product"));
                ReceiveTest.this.assertStType(ReceiveTest.this.getVariableValue(result, "stType"));
                ReceiveTest.this.assertStElement(ReceiveTest.this.getVariableValue(result, "stElement"));
                ReceiveTest.this.assertIntType(ReceiveTest.this.getVariableValue(result, "intType"));
                ReceiveTest.this.assertIntElement(ReceiveTest.this.getVariableValue(result, "intElement"));
                return null;
            }
        });
        this.deleteInstance(result);
        return endTime;
    }

    private void assertStType(Object o) {
        Assert.assertTrue((String)"stType is not an instance of Element", (boolean)(o instanceof Element));
        Element defaultElement = (Element)o;
        Assert.assertEquals((String)"http://orchestra.ow2.org", (String)defaultElement.getNamespaceURI());
        Assert.assertEquals((String)"ORCHESTRA_anonymous_element", (String)defaultElement.getLocalName());
        Assert.assertEquals((String)"Dupont", (String)defaultElement.getTextContent());
    }

    private void assertStElement(Object o) {
        Assert.assertTrue((String)"stElement is not an instance of Element", (boolean)(o instanceof Element));
        Element stElement = this.assertTopElementNS(o, "string");
        Assert.assertEquals((String)"stringElementContent", (String)stElement.getTextContent());
    }

    private void assertIntType(Object o) {
        Assert.assertTrue((String)"intType is not an instance of Element", (boolean)(o instanceof Element));
        Element defaultElement = (Element)o;
        Assert.assertEquals((String)"http://orchestra.ow2.org", (String)defaultElement.getNamespaceURI());
        Assert.assertEquals((String)"ORCHESTRA_anonymous_element", (String)defaultElement.getLocalName());
        Assert.assertEquals((String)"5", (String)defaultElement.getTextContent());
    }

    private void assertIntElement(Object o) {
        Assert.assertTrue((String)"intElement is not an instance of Element", (boolean)(o instanceof Element));
        Element intElement = this.assertTopElementNS(o, "int");
        Assert.assertEquals((String)"6", (String)intElement.getTextContent());
    }

    private void assertMessage(Object o) {
        Assert.assertTrue((String)"request is not an instance of Message", (boolean)(o instanceof MessageVariable));
        MessageVariable message = (MessageVariable)o;
        this.assertProduct(message.getPartValue("product"));
        this.assertStElement(message.getPartValue("stElement"));
        this.assertIntType(message.getPartValue("intType"));
    }

    private void assertProduct(Object o) {
        Assert.assertTrue((String)"product is not an instance of Element", (boolean)(o instanceof Element));
        Element bigProduct = this.assertTopElementNS(o, "bigProduct");
        Assert.assertEquals((String)"123", (String)bigProduct.getAttribute("amount"));
        Assert.assertEquals((String)"chips", (String)bigProduct.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(bigProduct, "name", "myProduct");
        this.assertElementNSContentAndNoChild(bigProduct, "quantity", "52");
        List myElementChildren = XmlUtil.elements((Element)bigProduct, (String)this.getProcessNamespace(), (String)"myElement");
        Assert.assertEquals((int)1, (int)myElementChildren.size());
        Node myElementNode = (Node)myElementChildren.get(0);
        Assert.assertTrue((boolean)(myElementNode instanceof Element));
        Element myElement = (Element)myElementNode;
        this.assertElementNSContentAndNoChild(myElement, "element1.1.1", "HelloWorld");
        this.assertElementNSContentAndNoChild(myElement, "element1.2", "123");
    }
}

