/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.perf;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.perf.RemotePerfTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FlowTest
extends RemotePerfTestCase {
    protected String getProcessName() {
        return "flow";
    }

    protected String getProcessNamespace() {
        return "http://example.com/flow";
    }

    public ProcessDefinition deploy() {
        return this.deploy(org.ow2.orchestra.test.perf.flow.FlowTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.flow.FlowTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        long endTime = -1L;
        Document document = XmlUtil.getDocumentFromString((String)"<submit><in>Dupont</in></submit>");
        SOAPMessage request = SOAPUtil.buildSOAPMessage((Document)document, (String)"http://example.com/flow/submit");
        String endpoint = this.getDefaultEndpoint("flowPort");
        try {
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            endTime = System.currentTimeMillis();
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, "flowResultABCDE_AE_BF");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while performing test", (Throwable)e);
        }
        return endTime;
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.getFirstChild());
            Assert.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            Assert.assertEquals((String)"out", (String)st.getLocalName());
            Assert.assertNotNull((Object)st.getFirstChild());
            Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            Assert.assertEquals((String)name, (String)text.getData());
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + XmlUtil.toString((Node)result));
            throw e;
        }
    }

    public void testFlow() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.flow";
    }
}

