/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.util;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.util.OrchestraUrlUtil;

public class AddressingUtilTest
extends TestCase {
    public void testReplacePropertiesInOrchestraURL() {
        Properties props = new Properties();
        props.setProperty("orchestra.servlet.host", "myHost");
        props.setProperty("orchestra.servlet.port", "4567");
        props.setProperty("orchestra.servlet.path", "myApp");
        String url = "http://localhost:12345/orchestra/myService";
        Assert.assertEquals((String)"http://localhost:12345/orchestra/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"http://localhost:12345/orchestra/myService", (Properties)props));
        String url2 = "${orchestra.ws.url}/myService";
        Assert.assertEquals((String)"http://myHost:4567/myApp/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"${orchestra.ws.url}/myService", (Properties)props));
        props.setProperty("orchestra.servlet.host", "myNewHost");
        props.setProperty("orchestra.servlet.port", "1234");
        props.setProperty("orchestra.servlet.path", "myNewApp");
        Assert.assertEquals((String)"http://myNewHost:1234/myNewApp/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"${orchestra.ws.url}/myService", (Properties)props));
        String url3 = "http://localhost:${orchestra.servlet.port}/orchestra/myService";
        String url4 = "http://localhost:${HttpDefaultPort}/orchestra/myService";
        Assert.assertEquals((String)"http://localhost:1234/orchestra/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"http://localhost:${orchestra.servlet.port}/orchestra/myService", (Properties)props));
        Assert.assertEquals((String)"http://localhost:1234/orchestra/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"http://localhost:${HttpDefaultPort}/orchestra/myService", (Properties)props));
        props.setProperty("orchestra.servlet.port", "4567");
        Assert.assertEquals((String)"http://localhost:4567/orchestra/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"http://localhost:${orchestra.servlet.port}/orchestra/myService", (Properties)props));
        Assert.assertEquals((String)"http://localhost:4567/orchestra/myService", (String)OrchestraUrlUtil.replacePropertiesInOrchestraURL((String)"http://localhost:${HttpDefaultPort}/orchestra/myService", (Properties)props));
    }
}

