/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.while_;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class WhileTest
extends BpelTestCase {
    public WhileTest() {
        super("http://example.com/while", "while");
    }

    public void testWhile() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        int nb = 10;
        int loop = 85;
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("nb", BpelXmlUtil.createElementWithContent((String)Integer.toString(10)));
        parts.put("loop", BpelXmlUtil.createElementWithContent((String)Integer.toString(85)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)callResult.getVariables().size(), (int)2);
                Object nbEnd = WhileTest.this.getVariableValue(callResult, "nb");
                Object loopEnd = WhileTest.this.getVariableValue(callResult, "loop");
                WhileTest.this.assertInt(nbEnd, 95);
                WhileTest.this.assertInt(loopEnd, 0);
                WhileTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertInt(Object o, int expected) {
        Assert.assertTrue((String)"int is not an instance of Element", (boolean)(o instanceof Element));
        Element defaultElement = (Element)o;
        Assert.assertEquals((String)"http://docs.oasis-open.org/wsbpel/2.0/process/executable", (String)defaultElement.getNamespaceURI());
        Assert.assertEquals((String)"ORCHESTRA_anonymous_element", (String)defaultElement.getLocalName());
        Assert.assertEquals((int)expected, (int)new Integer(defaultElement.getTextContent()));
    }
}

