/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestCase
extends TestCase {
    private static final String ORCHESTRA_DEFAULT_URL = "http://localhost:8080/orchestra/";
    private static final Logger LOG = Logger.getLogger(RemoteTestCase.class.getName());
    protected Properties orchestraProperties = new Properties();
    protected String jmxServiceUrl;
    protected String jmxObjectName;

    public RemoteTestCase() {
        try {
            this.orchestraProperties.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("orchestra.properties"));
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException((Exception)e);
        }
        this.jmxServiceUrl = this.orchestraProperties.getProperty("orchestra.jmx.serviceUrl");
        this.jmxObjectName = this.orchestraProperties.getProperty("orchestra.jmx.objectName");
    }

    protected void deploy(String processName) {
        this.deploy(processName, null);
    }

    protected void deploy(String processName, List<URL> wsdls) {
        this.deploy(((Object)((Object)this)).getClass().getResource(processName + ".bpel"), wsdls);
    }

    protected void deploy(URL bpel, URL wsdl) {
        ArrayList<URL> wsdls = new ArrayList<URL>();
        wsdls.add(wsdl);
        this.deploy(bpel, wsdls);
    }

    protected void updateWsdlUrls(Deployment bpelDeployment) {
        Map wsdlDefinitions = bpelDeployment.getWsdlDefinitions().getWsdlDefinitions();
        if (ORCHESTRA_DEFAULT_URL.equals(this.getDefaultEndpoint(""))) {
            return;
        }
        for (Set defSet : wsdlDefinitions.values()) {
            for (Definition def : defSet) {
                Map services = def.getServices();
                for (Service service : services.values()) {
                    Map ports = service.getPorts();
                    for (Port port : ports.values()) {
                        List elements = port.getExtensibilityElements();
                        for (ExtensibilityElement element : elements) {
                            if (!(element instanceof SOAPAddress)) continue;
                            SOAPAddress address = (SOAPAddress)element;
                            String addressURI = address.getLocationURI();
                            String updatedAddress = addressURI.replace(ORCHESTRA_DEFAULT_URL, this.getDefaultEndpoint(""));
                            address.setLocationURI(updatedAddress);
                        }
                    }
                }
            }
        }
    }

    protected void deploy(URL bpel, List<URL> wsdls) {
        Deployment bpelDeployment = DeploymentUtil.generateDeployment((URL)bpel, wsdls);
        this.updateWsdlUrls(bpelDeployment);
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            Assert.assertNotNull((Object)remoteDeployer.deploy(bpelDeployment));
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    protected void undeploy(QName processQName) {
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            Assert.assertTrue((boolean)remoteDeployer.undeploy(processQName));
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    protected SOAPBodyElement getSOAPBodyElement(SOAPMessage response) {
        if (response == null) {
            throw new OrchestraRuntimeException("response is null");
        }
        try {
            SOAPBody soapBody = response.getSOAPBody();
            if (soapBody == null) {
                throw new OrchestraRuntimeException("response.soapBody is null");
            }
            Iterator it = soapBody.getChildElements();
            SOAPBodyElement result = null;
            while (it.hasNext()) {
                Node item = (Node)it.next();
                if (!(item instanceof SOAPBodyElement)) continue;
                if (result != null) {
                    throw new OrchestraRuntimeException("response.soapBody.children has more than one child");
                }
                result = (SOAPBodyElement)item;
            }
            if (result == null) {
                throw new OrchestraRuntimeException("response.soapBody.children has no child");
            }
            return result;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while getting soapBodyElement of message : " + response, e);
        }
    }

    protected String getDefaultEndpoint(String portName) {
        String endpoint = "http://" + this.orchestraProperties.getProperty("orchestra.servlet.host") + ":" + this.orchestraProperties.getProperty("orchestra.servlet.port") + "/" + this.orchestraProperties.getProperty("orchestra.servlet.path") + "/" + portName;
        return endpoint;
    }

    public <E extends BpelFaultException> E waitForExceptionInInstance(QName processQName, Class<E> exceptionClass, QName faultName) throws Exception {
        long pollInterval = 1000L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
        while (startTime + 180000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            List processDefinitions = remoteDeployer.findProcessDefinitions(processQName);
            for (ProcessDefinition processDefinition : processDefinitions) {
                Set processInstances = remoteDeployer.findProcessInstances(processDefinition.getProcessDefinitionUUID());
                for (ProcessInstance processInstance : processInstances) {
                    Set activityInstances = remoteDeployer.findActivityInstances(processInstance.getProcessInstanceUUID());
                    for (ActivityInstance activityInstance : activityInstances) {
                        BpelFaultException exception = activityInstance.getLastException();
                        if (exception == null) continue;
                        if (!exceptionClass.isInstance(exception)) {
                            Assert.fail((String)("Exception is instance of " + exception.getClass().getName() + ". Expecting " + exceptionClass.getName()));
                            continue;
                        }
                        if (faultName != null) {
                            Assert.assertEquals((Object)faultName, (Object)exception.getFaultName());
                        }
                        return (E)((BpelFaultException)exceptionClass.cast(exception));
                    }
                }
            }
        }
        Assert.fail((String)"Exception not detected when timeout occured.");
        return null;
    }

    protected void tearDown() throws Exception {
        LOG.log(Level.INFO, "=== ending " + this.getName() + " =============================\n");
        super.tearDown();
    }

    public void setUp() throws Exception {
        LOG.log(Level.INFO, "=== starting " + this.getName() + " =============================\n");
    }
}

