/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.marketplace;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class MarketplaceTest
extends AbstractPerfTestCase {
    public MarketplaceTest() {
        super("http://orchestra.ow2.org/marketplace", "marketplace");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        String item = "item" + Thread.currentThread().getName();
        final int buyerPrice = Misc.random((int)0, (int)1000);
        final int sellerPrice = Misc.random((int)-45, (int)1000);
        final BuyerThread buyerThread = new BuyerThread(item, buyerPrice);
        final SellerThread sellerThread = new SellerThread(item, sellerPrice);
        buyerThread.start();
        sellerThread.start();
        try {
            while (!buyerThread.ended || !sellerThread.ended) {
                buyerThread.join(1000L);
                sellerThread.join(1000L);
                if (buyerThread.exception != null) {
                    throw buyerThread.exception;
                }
                if (sellerThread.exception == null) continue;
                throw sellerThread.exception;
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                BpelTestCase.CallResult buyerResult = buyerThread.callResult;
                BpelTestCase.CallResult sellerResult = sellerThread.callResult;
                MessageVariable buyerReply = buyerResult.getMessageCarrier().getMessage();
                MessageVariable sellerReply = sellerResult.getMessageCarrier().getMessage();
                if (buyerReply == null) {
                    throw new OrchestraRuntimeException("buyerReply is null");
                }
                if (sellerReply == null) {
                    throw new OrchestraRuntimeException("sellerReply is null");
                }
                Element buyerElement = buyerReply.getPartValue("outcome");
                if (buyerElement == null) {
                    throw new OrchestraRuntimeException("buyerReply.outcome is null");
                }
                Element sellerElement = sellerReply.getPartValue("outcome");
                if (sellerElement == null) {
                    throw new OrchestraRuntimeException("sellerReply.outcome is null");
                }
                String buyerOutcome = buyerElement.getTextContent();
                if (buyerOutcome == null) {
                    throw new OrchestraRuntimeException("buyerReply.outcome.textContent is null");
                }
                String sellerOutcome = sellerElement.getTextContent();
                if (sellerOutcome == null) {
                    throw new OrchestraRuntimeException("sellerReply.outcome.textContent is null");
                }
                MarketplaceTest.chekOutcomes(buyerPrice, buyerOutcome, sellerPrice, sellerOutcome);
                if (buyerResult.getProcessInstanceUUID() != null) {
                    MarketplaceTest.this.deleteInstance(buyerResult);
                } else {
                    MarketplaceTest.this.deleteInstance(sellerResult);
                }
                return null;
            }
        });
        return endTime;
    }

    public static void chekOutcomes(int buyerPrice, String buyerOutcome, int sellerPrice, String sellerOutcome) {
        String success = "Deal Successful";
        String fail = "Deal Failed";
        if (buyerPrice >= sellerPrice) {
            if (!buyerOutcome.equals("Deal Successful")) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and buyer outcome is not 'Deal Successful', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals("Deal Successful")) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and seller outcome is not 'Deal Successful', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        } else {
            if (!buyerOutcome.equals("Deal Failed")) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and buyer outcome is not 'Deal Failed', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals("Deal Failed")) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and seller outcome is not 'Deal Failed', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        }
    }

    public void testMarketplace() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "class.market";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SellerThread
    extends MPThread {
        public SellerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Element> getParts() {
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("inventoryItem", BpelXmlUtil.createElementWithContent((String)this.item));
            parts.put("askingPrice", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)));
            return parts;
        }

        @Override
        public String getOperationName() {
            return "seller";
        }

        @Override
        public QName getPortTypeQName() {
            return new QName(MarketplaceTest.this.getProcessNamespace(), "sellerPT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BuyerThread
    extends MPThread {
        public BuyerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Element> getParts() {
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("item", BpelXmlUtil.createElementWithContent((String)this.item));
            parts.put("offer", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)));
            return parts;
        }

        @Override
        public String getOperationName() {
            return "buyer";
        }

        @Override
        public QName getPortTypeQName() {
            return new QName(MarketplaceTest.this.getProcessNamespace(), "buyerPT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class MPThread
    extends Thread {
        protected String item;
        protected int price;
        protected BpelTestCase.CallResult callResult;
        protected RuntimeException exception = null;
        protected boolean ended = false;

        public MPThread(String item, int price) {
            this.item = item;
            this.price = price;
        }

        public abstract HashMap<String, Element> getParts();

        public abstract String getOperationName();

        public abstract QName getPortTypeQName();

        @Override
        public void run() {
            try {
                this.callResult = MarketplaceTest.this.call(this.getParts(), this.getPortTypeQName(), this.getOperationName());
            }
            catch (RuntimeException e) {
                this.exception = e;
                throw e;
            }
            finally {
                this.ended = true;
            }
        }
    }
}

