/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.model.OpenExecution;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Element;

public class InstanceManagementSuspendTest
extends BpelTestCase {
    private static final InstanceManagementAPI REMOTEDEPLOYER = new RemoteDeployerImpl();
    private final long time = 1L;

    public InstanceManagementSuspendTest() {
        super("http://orchestra.ow2.org/SuspendTest", "SuspendTest");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public Object[] launch(String message, SaveWS saveWS) {
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "SuspendTestOperation";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "SuspendTestOperation");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID processInstanceUUID = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) throws Exception {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
        return new Object[]{processInstanceUUID, callResult};
    }

    private void deleteInstanceMethod(BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                InstanceManagementSuspendTest.this.deleteInstances(1);
                return null;
            }
        });
    }

    private boolean isInstanceSuspended(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        return (Boolean)commandService.execute((Command)new Command<Boolean>(){
            private boolean result = true;

            public Boolean execute(Environment environment) throws Exception {
                BpelExecution instance = callResult.getInstance();
                boolean bool = instance.isInstanceSuspended();
                this.checkFinalNodes(instance);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, String.valueOf(bool && this.result));
                return bool && this.result;
            }

            private void checkFinalNodes(BpelExecution node) {
                if (!node.getExecutions().isEmpty()) {
                    for (OpenExecution n : node.getExecutions()) {
                        this.checkFinalNodes((BpelExecution)n);
                    }
                } else if (node.isSuspended() || "async".equals(node.getState())) {
                    this.result &= true;
                } else {
                    this.result &= false;
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, node + " is not suspended but " + node.getState());
                }
            }
        });
    }

    public void testSuspendInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            Assert.assertEquals((boolean)false, (boolean)this.isInstanceSuspended((BpelTestCase.CallResult)result[1]));
            REMOTEDEPLOYER.suspend((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceSuspended((BpelTestCase.CallResult)result[1]));
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
    }

    public void testSuspendSuspendedInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            REMOTEDEPLOYER.suspend((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceSuspended((BpelTestCase.CallResult)result[1]));
            REMOTEDEPLOYER.suspend((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceSuspended((BpelTestCase.CallResult)result[1]));
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
    }

    public void testSuspendBadInstance() {
        try {
            REMOTEDEPLOYER.suspend(new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$")));
            Assert.fail((String)"The instance should not have been found.");
        }
        catch (InstanceNotFoundException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }
}

