/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.rethrow;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.FaultWithMessage;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.FailWS;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class RethrowTest
extends BpelTestCase {
    public RethrowTest() {
        super("http://orchestra.ow2.org/rethrow", "rethrow", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testRethrowWithInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch();
        this.undeploy();
    }

    public void testRethrowWithScope() throws Exception {
        this.deploy("Scope");
        this.launch();
        this.undeploy();
    }

    public void deploy(String suffix) {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + suffix + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch() {
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        WSRepository.addWS(FailWS.PORTTYPE_QNAME, new FailWS());
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        this.call(parts, portTypeQName, "resume");
        FaultWithMessage fault = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), FaultWithMessage.class);
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        this.deleteInstances(1);
        Assert.assertEquals((String)"http://orchestra.ow2.org/failWS", (String)fault.getFaultName().getNamespaceURI());
        Assert.assertEquals((String)"The FailWS has failed", (String)fault.getFaultName().getLocalPart());
        WSRepository.removeWS(FailWS.PORTTYPE_QNAME);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }
}

