/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime.incomingcalls.pick;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.runtime.BpelTestCaseRuntime;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class TestSMMRPick
extends BpelTestCaseRuntime {
    public TestSMMRPick() {
        super("http://orchestra.ow2.org/SuspendResumeTwoMessagesPick", "SuspendResumeTwoMessagesPick");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void testSuspendMessageResume() {
        this.deploy();
        this.launchSMMR();
        this.undeploy();
    }

    public void launchSMMR() {
        String message1 = "Message 1";
        String message2 = "Message 2";
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        BpelTestCase.CallResult callResult = this.call(new HashMap<String, Element>(), portTypeQName, "SuspendResumeTwoMessagesPickOperation");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("message", BpelXmlUtil.createElementWithContent((String)"Message 1"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("message", BpelXmlUtil.createElementWithContent((String)"Message 2"));
        this.suspendInstanceMethod(callResult);
        this.call(parts1, new QName("http://orchestra.ow2.org/SendMessagePickTest", "SendMessagePickTestPortType"), "SendMessagePickTestOperation");
        this.call(parts2, new QName("http://orchestra.ow2.org/SendSecondMessagePickTest", "SendSecondMessagePickTestPortType"), "SendSecondMessagePickTestOperation");
        Assert.assertEquals((String)"", (String)saveWS.getBuffer());
        this.resumeInstanceMethod(callResult);
        this.waitForInstanceEnd(this.getpiuuid(callResult));
        String waitingMessage = null;
        String oldMessage = null;
        if ("Message 1".equals(saveWS.getBuffer())) {
            waitingMessage = "Message 2";
            oldMessage = "Message 1";
        } else if ("Message 2".equals(saveWS.getBuffer())) {
            waitingMessage = "Message 1";
            oldMessage = "Message 2";
        } else {
            Assert.fail((String)"Either message1 or message2 should be saved, nothing else ...");
        }
        BpelTestCase.CallResult callResultFinal = this.call(new HashMap<String, Element>(), portTypeQName, "SuspendResumeTwoMessagesPickOperation");
        this.waitForInstanceEnd(this.getpiuuid(callResultFinal));
        Assert.assertEquals((String)(oldMessage + waitingMessage), (String)saveWS.getBuffer());
        this.deleteInstanceMethod(2);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
    }
}

