/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

public class RemoteDeployerTest
extends BpelTestCase {
    private static final String QNAME = "{http://orchestra.ow2.org/demos/orderingService}orderingService";
    private RemoteDeployerImpl remoteDeployer;
    private QName processQName;

    public void setUp() throws Exception {
        super.setUp();
        this.remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
    }

    public void tearDown() throws Exception {
        this.remoteDeployer = null;
        super.tearDown();
    }

    public RemoteDeployerTest() {
        super("http://orchestra.ow2.org/orderingService", "orderingService");
    }

    public byte[] generateBarContent() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream(new BufferedOutputStream(baos));
        byte[] bpelContent = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"));
        byte[] wsdlContent = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String processName = this.getProcessName();
        if (processName != null && bpelContent != null && wsdlContent != null) {
            JarEntry entry = new JarEntry(this.getProcessName() + ".bpel");
            out.putNextEntry(entry);
            out.write(bpelContent);
            entry = new JarEntry(this.getProcessName() + ".wsdl");
            out.putNextEntry(entry);
            out.write(wsdlContent);
        }
        out.flush();
        Misc.close((Closeable)out);
        return baos.toByteArray();
    }

    public QName deployBar(RemoteDeployerImpl remoteDeployerImpl) throws IOException {
        byte[] bar = this.generateBarContent();
        ProcessDefinition processDefinition = remoteDeployerImpl.deployBar(bar);
        this.processQName = new QName(processDefinition.getNameSpace(), processDefinition.getName());
        return this.processQName;
    }

    public void testDeployNotNullDeployment() throws IOException {
        URL bpelFile = ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel");
        ArrayList<URL> wsdls = new ArrayList<URL>();
        wsdls.add(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        Deployment deployment = DeploymentUtil.generateDeployment((URL)bpelFile, wsdls);
        ProcessDefinition processDefinition = this.remoteDeployer.deploy(deployment);
        this.processQName = new QName(processDefinition.getNameSpace(), processDefinition.getName());
        Assert.assertTrue((boolean)this.processQName.toString().contains(QNAME));
        this.remoteDeployer.undeploy(this.processQName);
    }

    public void testDeployNullDeployment() {
        try {
            this.remoteDeployer.deploy(null);
            Assert.fail((String)"Deployment must be not null");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUndeploy() throws IOException {
        this.processQName = this.deployBar(this.remoteDeployer);
        boolean undeployed = this.remoteDeployer.undeploy(this.processQName);
        Assert.assertTrue((boolean)undeployed);
    }

    public void testUndeployBadProcess() {
        try {
            this.remoteDeployer.undeploy(this.processQName);
            Assert.fail((String)"Process Not found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUndeployNullQName() throws IOException {
        try {
            this.remoteDeployer.undeploy((QName)null);
            Assert.fail((String)"QName must be not null");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDeployBarNull() {
        try {
            this.remoteDeployer.deployBar(null);
            Assert.fail((String)"Bar file must be not null");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDeployBarNotNull() throws IOException {
        byte[] bar = this.generateBarContent();
        ProcessDefinition processDefinition = this.remoteDeployer.deployBar(bar);
        this.processQName = new QName(processDefinition.getNameSpace(), processDefinition.getName());
        Assert.assertTrue((boolean)this.processQName.toString().contains(QNAME));
        this.remoteDeployer.undeploy(this.processQName);
    }
}

