/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.receiveFlow;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ReceiveFlowTest
extends RemoteTestCase {
    public void testAxisReceiveFlow() {
        String processName = "receiveFlow";
        String processNamespace = "http://orchestra.ow2.org/tests/receiveFlow";
        QName processQName = new QName("http://orchestra.ow2.org/tests/receiveFlow", "receiveFlow");
        this.deploy("receiveFlow");
        String part = "<request>create</request>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveFlow/createInstance", (String)"<request>create</request>");
        String endpoint = this.getDefaultEndpoint("createFlowPort");
        SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
        Assert.assertNull((Object)response);
        ReceiveFlowThread firstCall = new ReceiveFlowThread("first");
        ReceiveFlowThread secondCall = new ReceiveFlowThread("second");
        ReceiveFlowThread thirdCall = new ReceiveFlowThread("third");
        Thread t1 = new Thread(firstCall);
        Thread t2 = new Thread(secondCall);
        Thread t3 = new Thread(thirdCall);
        t1.start();
        t2.start();
        t3.start();
        try {
            while (!(firstCall.isFinished() && secondCall.isFinished() && thirdCall.isFinished())) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread 1").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread 2").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread 3").initCause(thirdCall.getTrowable());
            }
            if (firstCall.getTrowable() != null) {
                throw new AssertionFailedError("Error in thread 1").initCause(firstCall.getTrowable());
            }
            if (secondCall.getTrowable() != null) {
                throw new AssertionFailedError("Error in thread 2").initCause(secondCall.getTrowable());
            }
            if (thirdCall.getTrowable() != null) {
                throw new AssertionFailedError("Error in thread 3").initCause(thirdCall.getTrowable());
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        this.undeploy(processQName);
    }

    class ReceiveFlowThread
    implements Runnable {
        private Throwable uncaughtException;
        private final String id;
        private boolean finished = false;

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public ReceiveFlowThread(String text) {
            this.id = text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String part = "<request>" + this.id + "</request>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveFlow/receive", (String)part);
                String endpoint = ReceiveFlowTest.this.getDefaultEndpoint("receiveFlowPort");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((String)XmlUtil.toString((Node)result), (boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)this.id, (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
            finally {
                this.finished = true;
            }
        }

        protected boolean isFinished() {
            return this.finished;
        }
    }
}

