/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.handlers.impl.CleanJournalFinishedInstanceHandler;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.services.runtime.JournalTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanJournalFinishedInstanceHandlerTest
extends BpelTestCase {
    private static final long TEST_TIMEOUT = 180000L;
    private ProcessInstanceUUID processInstanceUUID;
    private ProcessInstanceUUID secondProcessInstanceUUID;
    private int initialRunned;
    private int minRunned;
    private int expectedRunned;

    public CleanJournalFinishedInstanceHandlerTest() {
        super("http://orchestra.ow2.org/dfih", "cleanjournalFIH", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testCleanJournalFIH() throws Exception {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    @Override
    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = JournalTest.getJournalEnvGenerator();
        envGenerator.setFinishedInstanceHandlerType(new Class[]{CleanJournalFinishedInstanceHandler.class});
        return envGenerator;
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("cleanjournalFIH.bpel"), ((Object)((Object)this)).getClass().getResource("dfih.wsdl"));
    }

    public void launch() throws Exception {
        final long testStartTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        BpelTestCase.CallResult initReceive1 = this.startProcess();
        long timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(this.continueProcess("p1"), timeout);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getQuerier();
                CleanJournalFinishedInstanceHandlerTest.this.initialRunned = querier.findProcessInstances(ActivityState.FINISHED).size();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)1, (int)processFullInstanceSet.size());
                CleanJournalFinishedInstanceHandlerTest.this.processInstanceUUID = ((ProcessFullInstance)processFullInstanceSet.iterator().next()).getUUID();
                Assert.assertTrue((String)"No activities found for the process", (querier.findActivityInstances(CleanJournalFinishedInstanceHandlerTest.this.processInstanceUUID).size() != 0 ? 1 : 0) != 0);
                return null;
            }
        });
        BpelTestCase.CallResult initReceive2 = this.startProcess();
        timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(this.continueProcess("p2"), timeout);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getQuerier();
                CleanJournalFinishedInstanceHandlerTest.this.initialRunned = querier.findProcessInstances(ActivityState.FINISHED).size();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((int)2, (int)processFullInstanceSet.size());
                Iterator it = processFullInstanceSet.iterator();
                CleanJournalFinishedInstanceHandlerTest.this.secondProcessInstanceUUID = ((ProcessFullInstance)it.next()).getUUID();
                if (CleanJournalFinishedInstanceHandlerTest.this.secondProcessInstanceUUID.equals((Object)CleanJournalFinishedInstanceHandlerTest.this.processInstanceUUID)) {
                    CleanJournalFinishedInstanceHandlerTest.this.secondProcessInstanceUUID = ((ProcessFullInstance)it.next()).getUUID();
                }
                Assert.assertTrue((String)"No activities found for the second process", (querier.findActivityInstances(CleanJournalFinishedInstanceHandlerTest.this.secondProcessInstanceUUID).size() != 0 ? 1 : 0) != 0);
                return null;
            }
        });
        this.minRunned = 3;
        this.expectedRunned = this.minRunned + 0;
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                try {
                    Querier querier = EnvTool.getQuerier();
                    while (!CleanJournalFinishedInstanceHandlerTest.this.assertOnActivityInstances(querier, CleanJournalFinishedInstanceHandlerTest.this.processInstanceUUID, CleanJournalFinishedInstanceHandlerTest.this.minRunned, CleanJournalFinishedInstanceHandlerTest.this.expectedRunned, 3, false)) {
                        Thread.sleep(500L);
                        if (System.currentTimeMillis() - testStartTime <= 180000L) continue;
                        Assert.fail((String)"timeout");
                    }
                    while (!CleanJournalFinishedInstanceHandlerTest.this.assertOnActivityInstances(querier, CleanJournalFinishedInstanceHandlerTest.this.secondProcessInstanceUUID, CleanJournalFinishedInstanceHandlerTest.this.minRunned, CleanJournalFinishedInstanceHandlerTest.this.expectedRunned, 3, false)) {
                        Thread.sleep(500L);
                        if (System.currentTimeMillis() - testStartTime <= 180000L) continue;
                        Assert.fail((String)"timeout");
                    }
                }
                catch (Exception e) {
                    throw new OrchestraWrapperException((Throwable)e);
                }
                return null;
            }
        });
        timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(this.continueProcess("p1"), timeout);
        this.minRunned = this.expectedRunned + 2;
        this.expectedRunned = this.minRunned + 4;
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                try {
                    Querier querier = EnvTool.getQuerier();
                    while (!CleanJournalFinishedInstanceHandlerTest.this.assertOnActivityInstances(querier, CleanJournalFinishedInstanceHandlerTest.this.processInstanceUUID, CleanJournalFinishedInstanceHandlerTest.this.minRunned, CleanJournalFinishedInstanceHandlerTest.this.expectedRunned, 0, true)) {
                        Thread.sleep(500L);
                        if (System.currentTimeMillis() - testStartTime <= 180000L) continue;
                        Assert.fail((String)"timeout");
                    }
                }
                catch (Exception e) {
                    throw new OrchestraWrapperException((Throwable)e);
                }
                return null;
            }
        });
        timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(initReceive1, timeout);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getQuerier();
                CleanJournalFinishedInstanceHandlerTest.this.assertOnProcessInstances(querier, CleanJournalFinishedInstanceHandlerTest.this.initialRunned, 1);
                return null;
            }
        });
        timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(this.continueProcess("p2"), timeout);
        timeout = testStartTime + 180000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            Assert.fail((String)"timeout");
        }
        this.waitForMessage(initReceive2, timeout);
        Thread.sleep(5000L);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getQuerier();
                CleanJournalFinishedInstanceHandlerTest.this.assertOnProcessInstances(querier, CleanJournalFinishedInstanceHandlerTest.this.initialRunned, 0);
                CleanJournalFinishedInstanceHandlerTest.this.deleteInstances(2);
                return null;
            }
        });
    }

    public BpelTestCase.CallResult startProcess() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inv", BpelXmlUtil.createElementWithContent((String)""));
        QName portTypeQName = new QName(this.getProcessNamespace(), "dfihPT");
        String operationName = "submit";
        return this.call(parts, portTypeQName, "submit");
    }

    public BpelTestCase.CallResult continueProcess(String correlationName) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inv", BpelXmlUtil.createElementWithContent((String)correlationName));
        QName portTypeQName = new QName(this.getProcessNamespace(), "dfihPT");
        String operationName = "continue";
        return this.call(parts, portTypeQName, "continue");
    }

    public MessageVariable waitForMessage(BpelTestCase.CallResult callResult, long timeout) throws TimeoutException {
        return callResult.getMessageCarrier().getMessage(timeout);
    }

    public boolean assertOnActivityInstances(Querier querier, ProcessInstanceUUID processUUID, int minRunned, int expectedRunned, int minRunning, boolean waitForClean) throws OrchestraException {
        int beforeTotalActivity = querier.findActivityInstances(processUUID).size();
        Set activityInstanceRunningSet = querier.findActivityInstances(processUUID, ActivityState.RUNNING);
        Set activityInstanceRunnedSet = querier.findActivityInstances(processUUID, ActivityState.FINISHED);
        int totalActivity = querier.findActivityInstances(processUUID).size();
        int runningActivity = activityInstanceRunningSet.size();
        int runnedActivity = activityInstanceRunnedSet.size();
        if (beforeTotalActivity == 0 && waitForClean) {
            Assert.assertEquals((int)0, (int)totalActivity);
            Assert.assertEquals((int)0, (int)runningActivity);
            Assert.assertEquals((int)0, (int)runnedActivity);
            return true;
        }
        Assert.assertTrue((minRunning <= runningActivity ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expect more activities already run (expected " + minRunned + " got " + runnedActivity + ")"), (runnedActivity >= minRunned ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expect less activities already run", (runnedActivity <= expectedRunned ? 1 : 0) != 0);
        int totalRun = this.calculTotalActivities(activityInstanceRunningSet, activityInstanceRunnedSet);
        Assert.assertTrue((String)"Issue in find requests", (beforeTotalActivity <= totalRun && totalRun <= totalActivity ? 1 : 0) != 0);
        if (!waitForClean) {
            return expectedRunned == runnedActivity;
        }
        return false;
    }

    private int calculTotalActivities(Set<ActivityFullInstance> ... activityInstanceSets) {
        HashSet<ActivityInstanceUUID> activityInstanceUUIDSet = new HashSet<ActivityInstanceUUID>();
        for (Set<ActivityFullInstance> activityInstanceSet : activityInstanceSets) {
            for (ActivityFullInstance activityInstance : activityInstanceSet) {
                activityInstanceUUIDSet.add(activityInstance.getUUID());
            }
        }
        return activityInstanceUUIDSet.size();
    }

    public void assertOnProcessInstances(Querier querier, int runned, int running) {
        int beforeTotalInstance = querier.findProcessInstances().size();
        Set processInstanceRunnedSet = querier.findProcessInstances(ActivityState.FINISHED);
        Set processInstanceRunningSet = querier.findProcessInstances(ActivityState.RUNNING);
        int totalInstance = querier.findProcessInstances().size();
        int runningInstance = processInstanceRunningSet.size();
        int runnedInstance = processInstanceRunnedSet.size();
        Assert.assertEquals((int)running, (int)runningInstance);
        Assert.assertEquals((int)runned, (int)runnedInstance);
        int totalRun = runnedInstance + runningInstance;
        Assert.assertTrue((String)("expected " + beforeTotalInstance + " <= " + totalRun + " && " + totalRun + " <= " + totalInstance), (beforeTotalInstance <= totalRun && totalRun <= totalInstance ? 1 : 0) != 0);
    }
}

