/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.fromTii;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class FromTiiTest
extends BpelTestCase {
    public FromTiiTest() {
        super("http://example.com/fromTii", "fromTii");
    }

    public void testFromTii() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL request = ((Object)((Object)this)).getClass().getResource("request.xml");
        this.assertExists(request);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)request).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)3, (int)callResult.getVariables().size());
                FromTiiTest.this.assertShippingAddressVar1(FromTiiTest.this.getVariableValue(callResult, "shippingAddressVar1"));
                FromTiiTest.this.assertShippingAddressVar2(FromTiiTest.this.getVariableValue(callResult, "shippingAddressVar2"));
                FromTiiTest.this.assertShippingPostalCodeVar(FromTiiTest.this.getVariableValue(callResult, "shippingPostalCodeVar"));
                FromTiiTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertShippingAddressVar1(Object o) {
        Element root = this.assertTopElementNS(o, "shippingAddress");
        Assert.assertEquals((String)"94304", (String)root.getAttribute("postCode"));
        this.assertNoElementChild(root);
    }

    private void assertShippingAddressVar2(Object o) {
        Element root = this.assertTopElementNS(o, "shippingAddress");
        Assert.assertEquals((String)"9035768", (String)root.getAttribute("id"));
        Element postlCode = this.assertElementNSContentAndNoChild(root, "postalCode", "94107");
        this.assertNoElementChild(postlCode);
    }

    private void assertShippingPostalCodeVar(Object o) {
        Element root = this.assertTopElementNS(o, "shippingPostalCode");
        Assert.assertEquals((String)"95110", (String)root.getTextContent());
        this.assertNoElementChild(root);
    }
}

