/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.throw_;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.FaultWithElement;
import org.ow2.orchestra.facade.exception.FaultWithMessage;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowTest
extends BpelTestCase {
    public ThrowTest() {
        super("http://orchestra.ow2.org/throw", "throw", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testThrowBpelFault() throws Exception {
        this.deploy("BpelFault");
        this.launch(BpelFaultException.class);
        this.undeploy();
    }

    public void testThrowUserFault() throws Exception {
        this.deploy("UserFault");
        this.launch(FaultWithMessage.class);
        this.undeploy();
    }

    public void testThrowUserElement() throws Exception {
        this.deploy("UserElement");
        FaultWithElement result = this.launch(FaultWithElement.class);
        this.undeploy();
        Assert.assertEquals((String)"throwElementValue", (String)result.getFaultElement().getTextContent());
    }

    public void deploy(String suffix) {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + suffix + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public <E extends Exception> E launch(Class<E> expectedException) {
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        this.call(parts, portTypeQName, "resume");
        E result = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), expectedException);
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        this.deleteInstances(1);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        return result;
    }
}

