/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message,
Serializable {
    private static final long serialVersionUID = -1923279216159214497L;
    protected Document parts;

    public MessageImpl() {
    }

    public MessageImpl(Document duplicateParts) {
        this.parts = duplicateParts;
    }

    public Element getPartElement(String partName) {
        if (partName != null) {
            return XmlUtil.element(this.parts.getDocumentElement(), partName);
        }
        return XmlUtil.element(this.parts.getDocumentElement());
    }

    @Override
    public Element getPartValue(String partName) {
        Element partElt = this.getPartElement(partName);
        return XmlUtil.element(partElt);
    }

    @Override
    public MessageImpl copy() {
        if (this.parts == null) {
            return null;
        }
        Document duplicateParts = XmlUtil.getNewDocument();
        Node n = duplicateParts.importNode(this.parts.getDocumentElement(), true);
        duplicateParts.appendChild(n);
        return new MessageImpl(duplicateParts);
    }

    @Override
    public Map<String, Element> getParts() {
        List<Element> partElements = XmlUtil.elements(this.parts.getDocumentElement());
        HashMap<String, Element> res = new HashMap<String, Element>();
        if (partElements != null) {
            for (Element elt : partElements) {
                res.put(elt.getTagName(), XmlUtil.element(elt));
            }
        }
        return res;
    }

    @Override
    public boolean hasPart(String partName) {
        return this.getPartElement(partName) != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(XmlUtil.toString(this.parts));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parts = XmlUtil.getDocumentFromString((String)in.readObject());
    }
}

