/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.query;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryTest
extends BpelTestCase {
    public QueryTest() {
        super("http://example.com/query", "query");
    }

    public void testQuery() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL bigProduct = ((Object)((Object)this)).getClass().getResource("bigProduct.xml");
        this.assertExists(bigProduct);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)bigProduct).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)8, (int)callResult.getVariables().size());
                QueryTest.this.assertString(QueryTest.this.getVariableValue(callResult, "st1"));
                QueryTest.this.assertElement(QueryTest.this.getVariableValue(callResult, "element1"));
                QueryTest.this.assertQuantity(QueryTest.this.getVariableValue(callResult, "quantity1"));
                QueryTest.this.assertToQuery(QueryTest.this.getVariableValue(callResult, "toQuery"));
                QueryTest.this.assertString(QueryTest.this.getVariableValue(callResult, "st2"));
                QueryTest.this.assertElement(QueryTest.this.getVariableValue(callResult, "element2"));
                QueryTest.this.assertQuantity(QueryTest.this.getVariableValue(callResult, "quantity2"));
                QueryTest.this.assertRequest(QueryTest.this.getVariableValue(callResult, "request"));
                QueryTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertString(Object o) {
        this.assertString(o, "myAttrValue");
    }

    private void assertElement(Object o) {
        Element element1 = this.assertTopElementNS(o, "element1.1.1");
        Assert.assertEquals((String)"HelloWorld", (String)element1.getTextContent());
    }

    private void assertQuantity(Object o) {
        Element quantity = this.assertTopElementNS(o, "quantity");
        Assert.assertEquals((String)"52", (String)quantity.getTextContent());
    }

    private void assertToQuery(Object o) {
        Element bigProduct = this.assertTopElementNS(o, "bigProduct");
        Assert.assertEquals((String)"", (String)bigProduct.getAttribute("amount"));
        Assert.assertEquals((String)"", (String)bigProduct.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(bigProduct, "name", "");
        this.assertElementNSContentAndNoChild(bigProduct, "quantity", "486");
        List myElementChildren = XmlUtil.elements((Element)bigProduct, (String)this.getProcessNamespace(), (String)"myElement");
        Assert.assertEquals((int)1, (int)myElementChildren.size());
        Node myElementNode = (Node)myElementChildren.get(0);
        Assert.assertTrue((boolean)(myElementNode instanceof Element));
        Element myElement = (Element)myElementNode;
        this.assertElementNSContentAndNoChild(myElement, "element1.1.1", "fromElement1");
        this.assertElementNSContentAndNoChild(myElement, "element1.2", "");
    }

    private void assertRequest(Object o) {
        Assert.assertTrue((String)"request is not an instance of Message", (boolean)(o instanceof MessageVariable));
        Element bigProductElement = ((MessageVariable)o).getPartValue("p");
        Element bigProduct = this.assertTopElementNS(bigProductElement, "bigProduct");
        Assert.assertEquals((String)"123", (String)bigProduct.getAttribute("amount"));
        Assert.assertEquals((String)"chips", (String)bigProduct.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(bigProduct, "name", "myProduct");
        this.assertElementNSContentAndNoChild(bigProduct, "quantity", "486");
        List myElementChildren = XmlUtil.elements((Element)bigProduct, (String)this.getProcessNamespace(), (String)"myElement");
        Assert.assertEquals((int)1, (int)myElementChildren.size());
        Node myElementNode = (Node)myElementChildren.get(0);
        Assert.assertTrue((boolean)(myElementNode instanceof Element));
        Element myElement = (Element)myElementNode;
        this.assertElementNSContentAndNoChild(myElement, "element1.1.1", "fromElement1");
        this.assertElementNSContentAndNoChild(myElement, "element1.2", "123");
    }
}

