/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.xsl;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XslTransformationTest
extends RemoteTestCase {
    private final String processName = "helloworld";
    private final String processNamespace = "http://example.com/helloworld";

    public void testRemoteXslTransformation() {
        try {
            SOAPBodyElement result;
            QName processQName = new QName(this.processNamespace, this.processName);
            this.deploy(this.processName);
            String part = "<submit xmlns='http://example.com/helloworld'><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/helloworld/submit", (String)part);
            String endpoint = this.getDefaultEndpoint("helloworldPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                result = this.getSOAPBodyElement(response);
                this.checkReturn(result, "Dupont");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<submit xmlns='http://example.com/helloworld'><st>Toto</st></submit>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/helloworld/submit", (String)part);
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                this.checkReturn(result, "Toto");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"transformedElement", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.processNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Assert.assertTrue((boolean)(result.getFirstChild() instanceof Element));
        Element st = (Element)result.getFirstChild();
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.processNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

