/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.versioning;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.IncompatibleWSDLException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HelloworldVersioningTest
extends RemoteTestCase {
    private final String processName = "helloworld";
    private final String processNamespace = "http://example.com/helloworld";

    public void testHelloworldVersioningAddRemoveNewVersion() throws SOAPException {
        String endpoint = this.getDefaultEndpoint("helloworldPort");
        ProcessDefinition pd1 = this.deploy(this.processName + "-v1");
        this.launchProcessInstance(endpoint, "Toto", "Toto");
        ProcessDefinition pd2 = this.deploy(this.processName + "-v2");
        this.launchProcessInstance(endpoint, "Toto", "hello Toto");
        this.undeploy(pd2.getUUID());
        this.launchProcessInstance(endpoint, "Toto", "Toto");
        this.undeploy(pd1.getUUID());
        try {
            this.launchProcessInstance(endpoint, "Toto", "Toto");
            Assert.fail((String)"Service should be unavailable");
        }
        catch (RuntimeException e) {
        }
        catch (ComparisonFailure e) {
            // empty catch block
        }
    }

    public void testHelloworldVersioningRemoveOldVersion() throws SOAPException {
        String endpoint = this.getDefaultEndpoint("helloworldPort");
        ProcessDefinition pd1 = this.deploy(this.processName + "-v1");
        this.launchProcessInstance(endpoint, "Toto", "Toto");
        ProcessDefinition pd2 = this.deploy(this.processName + "-v2");
        this.launchProcessInstance(endpoint, "Toto", "hello Toto");
        this.undeploy(pd1.getUUID());
        this.launchProcessInstance(endpoint, "Toto", "hello Toto");
        this.undeploy(pd2.getUUID());
    }

    public void testHelloworldVersioningWSDLChanged() throws SOAPException {
        ProcessDefinition pd1 = this.deploy(this.processName + "-v1");
        try {
            this.deploy(this.processName + "-v3");
            Assert.fail((String)"exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
        this.undeploy(pd1.getUUID());
        ProcessDefinition pd3 = this.deploy(this.processName + "-v3");
        this.undeploy(pd3.getUUID());
    }

    public void testVersioningProcessNameChanged() throws SOAPException {
        ProcessDefinition pd1 = this.deploy("helloworld-v1");
        try {
            this.deploy("hello-v1");
            Assert.fail((String)"exception expected");
        }
        catch (DeploymentException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("/orchestra/helloworldPort is already used by process {http://example.com/helloworld}helloworld"));
        }
        this.undeploy(pd1.getUUID());
        ProcessDefinition pd2 = this.deploy("hello-v1");
        this.undeploy(pd2.getUUID());
    }

    private void launchProcessInstance(String endpoint, String input, String expectedOutput) throws SOAPException {
        String part = "<submit xmlns='http://example.com/helloworld'><st>" + input + "</st></submit>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/helloworld/submit", (String)part);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
        if (response != null) {
            SOAPBodyElement result = this.getSOAPBodyElement(response);
            this.checkReturn(result, expectedOutput);
        } else {
            Assert.assertTrue((String)"No return available", (boolean)false);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"submit", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.processNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Element st = XmlUtil.element((Element)result);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.processNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

