/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.def.impl;

import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ProcessStateUpdate;
import org.ow2.orchestra.facade.def.impl.ScopeActivityDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionImpl
extends ScopeActivityDefinitionImpl
implements ProcessDefinition {
    private static final long serialVersionUID = 35906774703995610L;
    protected String nameSpace;
    private final String expressionLanguage;
    private final String queryLanguage;
    private final Date deployedDate;
    private final Date undeployedDate;
    private final ProcessState state;
    private final List<ProcessStateUpdate> stateUpdates;
    private final int version;

    public ProcessDefinitionImpl(ProcessDefinition src) {
        super(src);
        this.enclosedActivityUUID = src.getEnclosedActivityUUID();
        this.nameSpace = src.getNameSpace();
        this.expressionLanguage = src.getExpressionLanguage();
        this.queryLanguage = src.getQueryLanguage();
        this.deployedDate = src.getDeployedDate();
        this.undeployedDate = src.getUndeployedDate();
        this.state = src.getState();
        this.stateUpdates = CopyUtil.copyList(src.getStateUpdates());
        this.version = src.getVersion();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ProcessDefinitionImpl other = (ProcessDefinitionImpl)obj;
        return other.getUUID().equals(this.getUUID());
    }

    @Override
    public ProcessDefinitionUUID getUUID() {
        return this.getProcessDefinitionUUID();
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    @Override
    public ActivityDefinitionUUID getEnclosedActivityUUID() {
        return this.enclosedActivityUUID;
    }

    public void setEnclosedActivityUUID(ActivityDefinitionUUID enclosedActivityUUID) {
        this.enclosedActivityUUID = enclosedActivityUUID;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    @Override
    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    @Override
    public Date getDeployedDate() {
        return this.deployedDate != null ? new Date(this.deployedDate.getTime()) : null;
    }

    @Override
    public Date getUndeployedDate() {
        return this.undeployedDate != null ? new Date(this.undeployedDate.getTime()) : null;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.PROCESS;
    }

    @Override
    public QName getQName() {
        return new QName(this.getNameSpace(), this.getName());
    }

    @Override
    public ProcessState getState() {
        return this.state;
    }

    @Override
    public List<ProcessStateUpdate> getStateUpdates() {
        return this.stateUpdates;
    }

    @Override
    public int getVersion() {
        return this.version;
    }
}

