/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.w3c.dom.Element;

public class InstanceManagementResumeTest
extends BpelTestCase {
    private InstanceManagementAPI remoteDeployer;
    private final long time = 1L;

    public void setUp() throws Exception {
        super.setUp();
        this.remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
    }

    public void tearDown() throws Exception {
        this.remoteDeployer = null;
        super.tearDown();
    }

    public InstanceManagementResumeTest() {
        super("http://orchestra.ow2.org/ExitTest", "ExitTest");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public Object[] launch(String message, SaveWS saveWS) {
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + this.time + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "ExitTestOperation";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "ExitTestOperation");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID processInstanceUUID = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
        return new Object[]{processInstanceUUID, callResult};
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                InstanceManagementResumeTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    private boolean isInstanceRunning(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        return (Boolean)commandService.execute((Command)new Command<Boolean>(){
            private boolean result = true;

            public Boolean execute(Environment environment) {
                BpelInstance instance = callResult.getInstance();
                boolean bool = instance.isInstanceSuspended();
                this.checkFinalNodes((BpelExecution)instance);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, String.valueOf(bool && this.result));
                return !bool && this.result;
            }

            private void checkFinalNodes(BpelExecution node) {
                if (!node.getExecutions().isEmpty()) {
                    for (BpelExecution n : node.getExecutions()) {
                        this.checkFinalNodes(n);
                    }
                } else {
                    this.result = this.result && !node.isSuspended();
                }
            }
        });
    }

    public void testResumeSuspendedInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceRunning((BpelTestCase.CallResult)result[1]));
            this.remoteDeployer.suspend((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)false, (boolean)this.isInstanceRunning((BpelTestCase.CallResult)result[1]));
            this.remoteDeployer.resume((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceRunning((BpelTestCase.CallResult)result[1]));
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        this.undeploy();
    }

    public void testResumeRunningInstance() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        Object[] result = this.launch(message, saveWS);
        try {
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceRunning((BpelTestCase.CallResult)result[1]));
            this.remoteDeployer.resume((ProcessInstanceUUID)result[0]);
            Assert.assertEquals((boolean)true, (boolean)this.isInstanceRunning((BpelTestCase.CallResult)result[1]));
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        this.waitForInstanceEnd((ProcessInstanceUUID)result[0]);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod((BpelTestCase.CallResult)result[1]);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void testResumeBadInstance() {
        try {
            this.remoteDeployer.resume(new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$")));
            Assert.fail((String)"The instance should not have been found.");
        }
        catch (InstanceNotFoundException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }
}

