/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.versioning;

import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.jmx.ManagementAPIImpl;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.if_.IfTest;
import org.w3c.dom.Element;

public class PendingMessageTest
extends BpelTestCase {
    public PendingMessageTest() {
        super("http://orchestra.ow2.org/demos/hello2", "hello2");
    }

    public void testDeletePendingMessages() throws TimeoutException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        QName portTypeQName = new QName(this.getProcessNamespace(), "helloPT");
        String operationName = "sayHello";
        OperationKey operationKey = new OperationKey(this.getProcessQName(), portTypeQName, "sayHello");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        ProcessDefinition pd1 = this.deployV1();
        this.call(parts, portTypeQName, "sayHello");
        Assert.assertEquals((int)1, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        ProcessDefinition pd3 = this.deployV1();
        ProcessDefinition pd2 = this.deployV2();
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        this.call(parts, portTypeQName, "sayHello");
        Assert.assertEquals((int)1, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd3.getProcessDefinitionUUID());
        Assert.assertEquals((int)1, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
    }

    public void testDeletePendingMessagesRemovedOperation() throws TimeoutException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        QName portTypeQName = new QName(this.getProcessNamespace(), "helloEndPT");
        String operationName = "setHelloEnd";
        OperationKey operationKey = new OperationKey(this.getProcessQName(), portTypeQName, "setHelloEnd");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        ProcessDefinition pd1 = this.deployV2();
        this.call(parts, portTypeQName, "setHelloEnd");
        Assert.assertEquals((int)1, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        ProcessDefinition pd3 = this.deployV2();
        ProcessDefinition pd2 = this.deployV1();
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        this.call(parts, portTypeQName, "setHelloEnd");
        Assert.assertEquals((int)1, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd3.getProcessDefinitionUUID());
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
        Assert.assertEquals((int)0, (int)this.getPendingMessages(operationKey));
    }

    private int getPendingMessages(final OperationKey operationKey) throws TimeoutException {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        return (Integer)commandService.execute((Command)new Command<Integer>(){

            public Integer execute(Environment environment) {
                return ((Repository)environment.get(Repository.class)).getPendingMessages(operationKey).size();
            }
        });
    }

    public ProcessDefinition deployV1() {
        return this.deploy(PendingMessageTest.class.getResource(this.getProcessName() + "-v1.bpel"), IfTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public ProcessDefinition deployV2() {
        return this.deploy(PendingMessageTest.class.getResource(this.getProcessName() + "-v2.bpel"), IfTest.class.getResource(this.getProcessName() + ".wsdl"));
    }
}

