/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.invoke;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.activities.invoke.InvokeTest;
import org.ow2.orchestra.test.wsutils.PersonWS;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InvokeAddPersonTest
extends BpelTestCase {
    public InvokeAddPersonTest() {
        super("http://example.com/invoke", "invokeAddPerson");
    }

    public void testInvokeAddPerson() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        URL personsList = ((Object)((Object)this)).getClass().getResource("personsList.xml");
        this.assertExists(personsList);
        URL person = ((Object)((Object)this)).getClass().getResource("person.xml");
        this.assertExists(person);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("personsList", XmlUtil.getDocumentFromURL((URL)personsList).getDocumentElement());
        parts.put("personToAdd", XmlUtil.getDocumentFromURL((URL)person).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "invokeAddPerson";
        WSRepository.addWS(PersonWS.PORTTYPE_QNAME, new PersonWS());
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "invokeAddPerson");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                MessageVariable reply = result.getMessageCarrier().getMessage();
                String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
                Assert.assertNotNull((Object)reply);
                Element element = reply.getPartValue("personsList");
                Assert.assertNotNull((String)("No part 'personsList' in reply, defined parts are: " + reply.getParts().keySet()), (Object)element);
                Assert.assertEquals((String)ns, (String)element.getNamespaceURI());
                Assert.assertEquals((String)"list", (String)element.getLocalName());
                List children = XmlUtil.elements((Element)element);
                Assert.assertEquals((int)3, (int)children.size());
                InvokeTest.assertPerson((Node)children.get(0), "Paul", "Glood", "21", "Jules Vernes", "75000", "Paris");
                InvokeTest.assertPerson((Node)children.get(1), "Roger", "Badin", "58", "Jean-Jacques ROUSSEAU", "13000", "Marseille");
                InvokeTest.assertPerson((Node)children.get(2), "Arthur", "Monulo", "5", "5 Avenue", "4444", "Los Angeles");
                InvokeAddPersonTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(PersonWS.PORTTYPE_QNAME);
        this.undeploy();
    }
}

