/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.result.ResultDiskBuffer;
import org.h2.result.ResultExternal;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.ResultTempTable;
import org.h2.result.SortOrder;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class LocalResult
implements ResultInterface,
ResultTarget {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private ValueHashMap<Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit;
    private ResultExternal disk;
    private int diskOffset;
    private boolean distinct;
    private boolean closed;

    public LocalResult() {
    }

    public LocalResult(Session session, Expression[] expressionArray, int n) {
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : session.getDatabase().getMaxMemoryRows();
        this.rows = New.arrayList();
        this.visibleColumnCount = n;
        this.rowId = -1;
        this.expressions = expressionArray;
    }

    public static LocalResult read(Session session, ResultSet resultSet, int n) {
        Expression[] expressionArray = Expression.getExpressionColumns(session, resultSet);
        int n2 = expressionArray.length;
        LocalResult localResult = new LocalResult(session, expressionArray, n2);
        try {
            for (int i = 0; (n == 0 || i < n) && resultSet.next(); ++i) {
                Value[] valueArray = new Value[n2];
                for (int j = 0; j < n2; ++j) {
                    int n3 = localResult.getColumnType(j);
                    valueArray[j] = DataType.readValue(session, resultSet, j + 1, n3);
                }
                localResult.addRow(valueArray);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        localResult.done();
        return localResult;
    }

    public LocalResult createShallowCopy(Session session) {
        if (this.disk == null && (this.rows == null || this.rows.size() < this.rowCount)) {
            return null;
        }
        LocalResult localResult = new LocalResult();
        localResult.maxMemoryRows = this.maxMemoryRows;
        localResult.session = session;
        localResult.visibleColumnCount = this.visibleColumnCount;
        localResult.expressions = this.expressions;
        localResult.rowId = -1;
        localResult.rowCount = this.rowCount;
        localResult.rows = this.rows;
        localResult.sort = this.sort;
        localResult.distinctRows = this.distinctRows;
        localResult.distinct = this.distinct;
        localResult.currentRow = null;
        localResult.offset = 0;
        localResult.limit = 0;
        localResult.disk = this.disk;
        localResult.diskOffset = this.diskOffset;
        return localResult;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sort = sortOrder;
    }

    public void setDistinct() {
        this.distinct = true;
        this.distinctRows = ValueHashMap.newInstance();
    }

    public void removeDistinct(Value[] valueArray) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        if (this.distinctRows != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            this.distinctRows.remove(valueArray2);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.disk.removeRow(valueArray);
        }
    }

    public boolean containsDistinct(Value[] valueArray) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        if (this.distinctRows != null) {
            ValueArray valueArray2 = ValueArray.get(valueArray);
            return this.distinctRows.get(valueArray2) != null;
        }
        return this.disk.contains(valueArray);
    }

    public void reset() {
        this.rowId = -1;
        if (this.disk != null) {
            this.disk.reset();
            if (this.diskOffset > 0) {
                for (int i = 0; i < this.diskOffset; ++i) {
                    this.disk.next();
                }
            }
        }
    }

    public Value[] currentRow() {
        return this.currentRow;
    }

    public boolean next() {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.disk != null ? this.disk.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    public int getRowId() {
        return this.rowId;
    }

    public void addRow(Value[] valueArray) {
        if (this.distinct) {
            if (this.distinctRows != null) {
                ValueArray valueArray2 = ValueArray.get(valueArray);
                this.distinctRows.put(valueArray2, valueArray);
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > SysProperties.MAX_MEMORY_ROWS_DISTINCT && this.session.getDatabase().isPersistent()) {
                    this.disk = new ResultTempTable(this.session, this.sort);
                    this.disk.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.disk.addRow(valueArray);
            }
            return;
        }
        this.rows.add(valueArray);
        ++this.rowCount;
        if (this.rows.size() > this.maxMemoryRows && this.session.getDatabase().isPersistent()) {
            if (this.disk == null) {
                this.disk = new ResultDiskBuffer(this.session, this.sort, valueArray.length);
            }
            this.addRowsToDisk();
        }
    }

    private void addRowsToDisk() {
        this.disk.addRows(this.rows);
        this.rows.clear();
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void done() {
        if (this.distinct) {
            if (this.distinctRows != null) {
                this.rows = this.distinctRows.values();
                this.distinctRows = null;
            } else if (this.disk != null && this.sort != null) {
                Value[] valueArray;
                ResultExternal resultExternal = this.disk;
                this.disk = null;
                resultExternal.reset();
                this.rows = New.arrayList();
                while ((valueArray = resultExternal.next()) != null) {
                    if (this.disk == null) {
                        this.disk = new ResultDiskBuffer(this.session, this.sort, valueArray.length);
                    }
                    this.rows.add(valueArray);
                    if (this.rows.size() <= this.maxMemoryRows) continue;
                    this.disk.addRows(this.rows);
                    this.rows.clear();
                }
                resultExternal.close();
            }
        }
        if (this.disk != null) {
            this.addRowsToDisk();
            this.disk.done();
        } else if (this.sort != null) {
            this.sort.sort(this.rows);
        }
        this.applyOffset();
        this.applyLimit();
        this.reset();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    private void applyLimit() {
        if (this.limit <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.rows.size() > this.limit) {
                this.rows = New.arrayList(this.rows.subList(0, this.limit));
                this.rowCount = this.limit;
            }
        } else if (this.limit < this.rowCount) {
            this.rowCount = this.limit;
        }
    }

    public boolean needToClose() {
        return this.disk != null;
    }

    public void close() {
        if (this.disk != null) {
            this.disk.close();
            this.disk = null;
            this.closed = true;
        }
    }

    public String getAlias(int n) {
        return this.expressions[n].getAlias();
    }

    public String getTableName(int n) {
        return this.expressions[n].getTableName();
    }

    public String getSchemaName(int n) {
        return this.expressions[n].getSchemaName();
    }

    public int getDisplaySize(int n) {
        return this.expressions[n].getDisplaySize();
    }

    public String getColumnName(int n) {
        return this.expressions[n].getColumnName();
    }

    public int getColumnType(int n) {
        return this.expressions[n].getType();
    }

    public long getColumnPrecision(int n) {
        return this.expressions[n].getPrecision();
    }

    public int getNullable(int n) {
        return this.expressions[n].getNullable();
    }

    public boolean isAutoIncrement(int n) {
        return this.expressions[n].isAutoIncrement();
    }

    public int getColumnScale(int n) {
        return this.expressions[n].getScale();
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    private void applyOffset() {
        if (this.offset <= 0) {
            return;
        }
        if (this.disk == null) {
            if (this.offset >= this.rows.size()) {
                this.rows.clear();
                this.rowCount = 0;
            } else {
                int n = Math.min(this.offset, this.rows.size());
                this.rows = New.arrayList(this.rows.subList(n, this.rows.size()));
                this.rowCount -= n;
            }
        } else if (this.offset >= this.rowCount) {
            this.rowCount = 0;
        } else {
            this.diskOffset = this.offset;
            this.rowCount -= this.offset;
        }
    }

    public String toString() {
        return "columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getFetchSize() {
        return 0;
    }

    public void setFetchSize(int n) {
    }
}

