/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WsdlInlineUtil {
    private WsdlInlineUtil() {
    }

    private static void inlineImportedXsds(Schema schema, Types types) {
        NodeList importsNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < importsNl.getLength(); ++i) {
            Element importElt = (Element)importsNl.item(i);
            if (!importElt.hasAttribute("schemaLocation")) continue;
            Map schemaImportsMap = schema.getImports();
            List schemaImports = (List)schemaImportsMap.get(importElt.getAttribute("namespace"));
            for (SchemaImport schemaImport : schemaImports) {
                if (schemaImport.getSchemaLocationURI() == null || !schemaImport.getSchemaLocationURI().equals(importElt.getAttribute("schemaLocation"))) continue;
                WsdlInlineUtil.inlineImportedXsds(schemaImport.getReferencedSchema(), types);
                schemaImport.setSchemaLocationURI(null);
                importElt.removeAttribute("schemaLocation");
                types.addExtensibilityElement(schemaImport.getReferencedSchema());
            }
        }
        NodeList includeNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (int i = 0; i < includeNl.getLength(); ++i) {
            Element includeElt = (Element)includeNl.item(i);
            if (!includeElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getIncludes()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(includeElt.getAttribute("schemaLocation"))) continue;
                WsdlInlineUtil.inlineImportedXsds(schemaReference.getReferencedSchema(), types);
                schemaReference.setSchemaLocationURI(null);
                includeElt.removeAttribute("schemaLocation");
                types.addExtensibilityElement(schemaReference.getReferencedSchema());
            }
        }
        NodeList redefinesNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "redefine");
        for (int i = 0; i < redefinesNl.getLength(); ++i) {
            Element redefineElt = (Element)redefinesNl.item(i);
            if (!redefineElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getRedefines()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(redefineElt.getAttribute("schemaLocation"))) continue;
                WsdlInlineUtil.inlineImportedXsds(schemaReference.getReferencedSchema(), types);
                schemaReference.setSchemaLocationURI(null);
                redefineElt.removeAttribute("schemaLocation");
                types.addExtensibilityElement(schemaReference.getReferencedSchema());
            }
        }
    }

    public static void inlineWsdlFile(Definition wsdlDefinition) {
        Types types;
        Map imports = wsdlDefinition.getImports();
        if (!imports.isEmpty()) {
            for (List l : imports.values()) {
                for (Import impor : l) {
                    Definition importedDefinition = impor.getDefinition();
                    WsdlInlineUtil.inlineWsdlFile(importedDefinition);
                }
            }
        }
        if ((types = wsdlDefinition.getTypes()) != null) {
            for (ExtensibilityElement elt : new ArrayList(types.getExtensibilityElements())) {
                if (!(elt instanceof Schema)) continue;
                Schema schema = (Schema)elt;
                WsdlInlineUtil.inlineImportedXsds(schema, types);
            }
        }
    }
}

