/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.receive;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class Receive2Test
extends BpelTestCase {
    public Receive2Test() {
        super("http://example.com/receive2", "receive2");
    }

    public void testReceive2() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public long launch() {
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("st", BpelXmlUtil.createElementWithContent((String)"receive1"));
        BpelTestCase.CallResult callResult1 = this.call(parts, portTypeQName, "op1");
        parts.put("st", BpelXmlUtil.createElementWithContent((String)"receive2"));
        BpelTestCase.CallResult callResult2 = this.call(parts, portTypeQName, "op2");
        long endTime = System.currentTimeMillis();
        MessageVariable response1 = callResult1.getMessageCarrier().getMessage();
        MessageVariable response2 = callResult2.getMessageCarrier().getMessage();
        this.assertStPart(response1, "receive1");
        this.assertStPart(response2, "receive2");
        this.deleteInstance(callResult1);
        return endTime;
    }

    private void assertStPart(MessageVariable m, String expected) {
        Element defaultElement = m.getPartValue("out");
        Assert.assertEquals((String)"http://example.com/receive2", (String)defaultElement.getNamespaceURI());
        Assert.assertEquals((String)"response", (String)defaultElement.getLocalName());
        Assert.assertEquals((String)expected, (String)defaultElement.getTextContent());
    }
}

