/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class NestedParallelForEachTest
extends BpelTestCase {
    public NestedParallelForEachTest() {
        super("http://orchestra.ow2.org/parallelForeach", "nestedParallelForeach");
    }

    public void testNestedForEach() {
        this.deploy();
        this.launch(1, 6, 3);
        this.undeploy();
    }

    public long launch(int start, int stop, int branches) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(start)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(stop)));
        parts.put("branches", BpelXmlUtil.createElementWithContent((String)Integer.toString(branches)));
        QName portTypeQName = new QName(this.getProcessNamespace(), "parallelForeachPT");
        String operationName = "start";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        long endTime = System.currentTimeMillis();
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        String[] counts = reply.getPartValue("count").getTextContent().split(",");
        NestedParallelForEachTest.assertTrue((boolean)counts[0].equals("s"));
        int expectedSize = branches;
        if (expectedSize < 0) {
            expectedSize = 0;
        }
        NestedParallelForEachTest.assertTrue(((expectedSize = expectedSize * 5 + 1) <= counts.length ? 1 : 0) != 0);
        NestedParallelForEachTest.assertTrue((counts.length <= Math.max(0, stop - start + 1) * 5 + 1 ? 1 : 0) != 0);
        this.deleteInstance(callResult);
        return endTime;
    }
}

