/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.def;

import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.ForDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.RepeatEveryDefinition;
import org.ow2.orchestra.facade.def.UntilDefinition;
import org.ow2.orchestra.facade.def.VariableDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnEventFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.def.full.ScopeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.SequenceActivityFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;

public abstract class AbstractEventHandlerDefinitionTest
extends WaitTestCase {
    public abstract Querier getQuerier();

    public AbstractEventHandlerDefinitionTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://orchestra.ow2.org/eventHandler", "eventHandler", environmentType);
    }

    public void testEventHandlerDefinition() {
        this.deploy();
        this.undeploy();
        this.launch();
    }

    public void launch() {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessFullDefinition processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new Command<ProcessFullDefinition>(){

            public ProcessFullDefinition execute(Environment environment) {
                Querier querier = AbstractEventHandlerDefinitionTest.this.getQuerier();
                List processFullDefinitionList = querier.findProcessDefinitions(AbstractEventHandlerDefinitionTest.this.getProcessQName(), ProcessState.UNDEPLOYED);
                Assert.assertEquals((int)1, (int)processFullDefinitionList.size());
                return ((ProcessFullDefinition)processFullDefinitionList.get(0)).fullCopy();
            }
        });
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        BpelActivityFullDefinition rootActivity = processFullDefinition.getEnclosedActivity();
        Assert.assertEquals((Object)ActivityType.SEQUENCE, (Object)rootActivity.getType());
        List sequenceActivities = ((SequenceActivityFullDefinition)rootActivity).getEnclosedActivities();
        Assert.assertEquals((int)2, (int)sequenceActivities.size());
        Assert.assertEquals((Object)ActivityType.RECEIVE, (Object)((BpelActivityFullDefinition)sequenceActivities.get(0)).getType());
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)((BpelActivityFullDefinition)sequenceActivities.get(1)).getType());
        ScopeActivityFullDefinition scopeDefinition = (ScopeActivityFullDefinition)sequenceActivities.get(1);
        List onEvents = scopeDefinition.getOnEventEventHandlers();
        Assert.assertEquals((int)3, (int)onEvents.size());
        this.checkOnEvent1((OnEventFullDefinition)onEvents.get(0));
        this.checkOnEvent2((OnEventFullDefinition)onEvents.get(1));
        this.checkOnEvent3((OnEventFullDefinition)onEvents.get(2));
        List onAlarms = scopeDefinition.getOnAlarmEventHandlers();
        Assert.assertEquals((int)2, (int)onAlarms.size());
        this.checkOnAlarm1((OnAlarmFullDefinition)onAlarms.get(0));
        this.checkOnAlarm2((OnAlarmFullDefinition)onAlarms.get(1));
    }

    private void checkOnAlarm1(OnAlarmFullDefinition onAlarm1) {
        Assert.assertNotNull((Object)onAlarm1.getForDefinition());
        ForDefinition onAlarm1For = onAlarm1.getForDefinition();
        Assert.assertEquals((String)"'PT25S'", (String)onAlarm1For.getDurationExpression());
        Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)onAlarm1For.getExpressionLanguage());
        Assert.assertNull((Object)onAlarm1.getUntilDefinition());
        Assert.assertNotNull((Object)onAlarm1.getRepeatEveryDefinition());
        RepeatEveryDefinition repeatEveryDefinition = onAlarm1.getRepeatEveryDefinition();
        Assert.assertEquals((String)"'PT4S'", (String)repeatEveryDefinition.getDurationExpression());
        Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)repeatEveryDefinition.getExpressionLanguage());
        BpelActivityFullDefinition onAlarm1enclosedActivity = onAlarm1.getActivityFullDefinition();
        Assert.assertNotNull((Object)onAlarm1enclosedActivity);
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)onAlarm1enclosedActivity.getType());
    }

    private void checkOnAlarm2(OnAlarmFullDefinition onAlarm1) {
        Assert.assertNull((Object)onAlarm1.getForDefinition());
        Assert.assertNotNull((Object)onAlarm1.getUntilDefinition());
        UntilDefinition untilDefinition = onAlarm1.getUntilDefinition();
        Assert.assertEquals((String)"'2000-03-04T20:00:00Z'", (String)untilDefinition.getDeadlineExpression());
        Assert.assertEquals((String)"urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", (String)untilDefinition.getExpressionLanguage());
        Assert.assertNull((Object)onAlarm1.getRepeatEveryDefinition());
        BpelActivityFullDefinition onAlarm1enclosedActivity = onAlarm1.getActivityFullDefinition();
        Assert.assertNotNull((Object)onAlarm1enclosedActivity);
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)onAlarm1enclosedActivity.getType());
    }

    private void checkOnEvent1(OnEventFullDefinition onEvent1) {
        Assert.assertEquals((String)"eventHandlerOperation", (String)onEvent1.getOperation());
        Assert.assertEquals((String)"knownPL", (String)onEvent1.getPartnerLink());
        Assert.assertEquals((String)"var", (String)onEvent1.getVariable());
        Assert.assertEquals((String)"known", (String)onEvent1.getMessageExchange());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "eventHandlerPortType"), (Object)onEvent1.getPortType());
        List onEvent1Correlations = onEvent1.getCorrelationDefinitionList();
        Assert.assertNotNull((Object)onEvent1Correlations);
        Assert.assertEquals((int)1, (int)onEvent1Correlations.size());
        Assert.assertEquals((String)"cs1", (String)((CorrelationDefinition)onEvent1Correlations.get(0)).getSet());
        Assert.assertEquals((String)"join", (String)((CorrelationDefinition)onEvent1Correlations.get(0)).getInitiate());
        List onEvent1FromPartDefinitions = onEvent1.getFromPartDefinitionList();
        Assert.assertNotNull((Object)onEvent1FromPartDefinitions);
        Assert.assertEquals((int)0, (int)onEvent1FromPartDefinitions.size());
        BpelActivityFullDefinition enclosedActivity = onEvent1.getActivityFullDefinition();
        Assert.assertNotNull((Object)enclosedActivity);
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)enclosedActivity.getType());
        ScopeActivityFullDefinition enclosedScope = (ScopeActivityFullDefinition)enclosedActivity;
        Assert.assertNotNull((Object)enclosedScope.getCorrelationSets());
        Assert.assertEquals((int)1, (int)enclosedScope.getCorrelationSets().size());
        Assert.assertNotNull((Object)enclosedScope.getMessageExchanges());
        Assert.assertEquals((int)1, (int)enclosedScope.getMessageExchanges().size());
        Assert.assertNotNull((Object)enclosedScope.getVariables());
        Assert.assertEquals((int)1, (int)enclosedScope.getVariables().size());
        VariableDefinition implicitVariable = (VariableDefinition)enclosedScope.getVariables().get(0);
        Assert.assertEquals((String)"var", (String)implicitVariable.getName());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "eventHandlerOperationRequest"), (Object)implicitVariable.getMessageType());
        Assert.assertNull((Object)implicitVariable.getElement());
        Assert.assertNull((Object)implicitVariable.getType());
    }

    private void checkOnEvent2(OnEventFullDefinition onEvent2) {
        Assert.assertEquals((String)"eventHandlerOperation", (String)onEvent2.getOperation());
        Assert.assertEquals((String)"eventHandlerPTL", (String)onEvent2.getPartnerLink());
        Assert.assertEquals((String)"var", (String)onEvent2.getVariable());
        Assert.assertNull((Object)onEvent2.getMessageExchange());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "eventHandlerPortType"), (Object)onEvent2.getPortType());
        List onEvent2Correlations = onEvent2.getCorrelationDefinitionList();
        Assert.assertNotNull((Object)onEvent2Correlations);
        Assert.assertEquals((int)0, (int)onEvent2Correlations.size());
        List onEvent1FromPartDefinitions = onEvent2.getFromPartDefinitionList();
        Assert.assertNotNull((Object)onEvent1FromPartDefinitions);
        Assert.assertEquals((int)0, (int)onEvent1FromPartDefinitions.size());
        BpelActivityFullDefinition enclosedActivity = onEvent2.getActivityFullDefinition();
        Assert.assertNotNull((Object)enclosedActivity);
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)enclosedActivity.getType());
        ScopeActivityFullDefinition enclosedScope = (ScopeActivityFullDefinition)enclosedActivity;
        Assert.assertNotNull((Object)enclosedScope.getCorrelationSets());
        Assert.assertEquals((int)0, (int)enclosedScope.getCorrelationSets().size());
        Assert.assertNotNull((Object)enclosedScope.getMessageExchanges());
        Assert.assertEquals((int)0, (int)enclosedScope.getMessageExchanges().size());
        Assert.assertNotNull((Object)enclosedScope.getVariables());
        Assert.assertEquals((int)1, (int)enclosedScope.getVariables().size());
        VariableDefinition implicitVariable = (VariableDefinition)enclosedScope.getVariables().get(0);
        Assert.assertEquals((String)"var", (String)implicitVariable.getName());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "element"), (Object)implicitVariable.getElement());
        Assert.assertNull((Object)implicitVariable.getMessageType());
        Assert.assertNull((Object)implicitVariable.getType());
    }

    private void checkOnEvent3(OnEventFullDefinition onEvent3) {
        Assert.assertEquals((String)"eventHandlerOperation", (String)onEvent3.getOperation());
        Assert.assertEquals((String)"eventHandlerPTL", (String)onEvent3.getPartnerLink());
        Assert.assertNull((Object)onEvent3.getVariable());
        Assert.assertNull((Object)onEvent3.getMessageExchange());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "eventHandlerPortType"), (Object)onEvent3.getPortType());
        List onEventCorrelations = onEvent3.getCorrelationDefinitionList();
        Assert.assertNotNull((Object)onEventCorrelations);
        Assert.assertEquals((int)0, (int)onEventCorrelations.size());
        List onEventFromPartDefinitions = onEvent3.getFromPartDefinitionList();
        Assert.assertNotNull((Object)onEventFromPartDefinitions);
        Assert.assertEquals((int)1, (int)onEventFromPartDefinitions.size());
        FromPartDefinition fromPartDefinition = (FromPartDefinition)onEventFromPartDefinitions.get(0);
        Assert.assertEquals((String)"payload", (String)fromPartDefinition.getPart());
        Assert.assertEquals((String)"var", (String)fromPartDefinition.getToVariable());
        BpelActivityFullDefinition enclosedActivity = onEvent3.getActivityFullDefinition();
        Assert.assertNotNull((Object)enclosedActivity);
        Assert.assertEquals((Object)ActivityType.SCOPE, (Object)enclosedActivity.getType());
        ScopeActivityFullDefinition enclosedScope = (ScopeActivityFullDefinition)enclosedActivity;
        Assert.assertNotNull((Object)enclosedScope.getCorrelationSets());
        Assert.assertEquals((int)0, (int)enclosedScope.getCorrelationSets().size());
        Assert.assertNotNull((Object)enclosedScope.getMessageExchanges());
        Assert.assertEquals((int)0, (int)enclosedScope.getMessageExchanges().size());
        Assert.assertNotNull((Object)enclosedScope.getVariables());
        Assert.assertEquals((int)1, (int)enclosedScope.getVariables().size());
        VariableDefinition implicitVariable = (VariableDefinition)enclosedScope.getVariables().get(0);
        Assert.assertEquals((String)"var", (String)implicitVariable.getName());
        Assert.assertEquals((Object)new QName(this.getProcessNamespace(), "element"), (Object)implicitVariable.getElement());
        Assert.assertNull((Object)implicitVariable.getMessageType());
        Assert.assertNull((Object)implicitVariable.getType());
    }
}

