/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.versioning;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.ManagementAPIImpl;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class MarketplaceVersioningTest
extends BpelTestCase {
    public MarketplaceVersioningTest() {
        super("http://orchestra.ow2.org/marketplace", "marketplace");
    }

    public ProcessDefinition deployV1() {
        return this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "-v1.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public ProcessDefinition deployV2() {
        return this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "-v2.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void testMarketPlaceVersions() throws InterruptedException {
        String item1 = Misc.getHumanReadableId((String)"item");
        int buyerPrice1 = Misc.random((int)0, (int)1000);
        int sellerPrice1 = Misc.random((int)-45, (int)1000);
        BuyerThread buyerThread1 = new BuyerThread(item1, buyerPrice1);
        SellerThread sellerThread1 = new SellerThread(item1, sellerPrice1);
        String item2 = Misc.getHumanReadableId((String)"item");
        int buyerPrice2 = Misc.random((int)0, (int)1000);
        int sellerPrice2 = Misc.random((int)-45, (int)1000);
        BuyerThread buyerThread2 = new BuyerThread(item2, buyerPrice2);
        SellerThread sellerThread2 = new SellerThread(item2, sellerPrice2);
        ProcessDefinition p1 = this.deployV1();
        buyerThread1.start();
        Thread.sleep(500L);
        ProcessDefinition p2 = this.deployV2();
        buyerThread2.start();
        Thread.sleep(500L);
        sellerThread1.start();
        sellerThread2.start();
        try {
            while (!(buyerThread1.ended && sellerThread1.ended && buyerThread2.ended && sellerThread2.ended)) {
                buyerThread1.join(1000L);
                sellerThread1.join(1000L);
                buyerThread2.join(1000L);
                sellerThread2.join(1000L);
                if (buyerThread1.exception != null) {
                    throw buyerThread1.exception;
                }
                if (sellerThread1.exception != null) {
                    throw sellerThread1.exception;
                }
                if (buyerThread2.exception != null) {
                    throw buyerThread2.exception;
                }
                if (sellerThread2.exception == null) continue;
                throw sellerThread2.exception;
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), (Throwable)e);
        }
        String success1 = "Deal OK";
        String fail1 = "Deal KO";
        String success2 = "Deal Successful";
        String fail2 = "Deal Failed";
        this.checkResults(buyerPrice1, sellerPrice1, buyerThread1, sellerThread1, "Deal OK", "Deal KO");
        this.checkResults(buyerPrice2, sellerPrice2, buyerThread2, sellerThread2, "Deal Successful", "Deal Failed");
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        managementAPI.undeploy(p1.getProcessDefinitionUUID());
        managementAPI.undeploy(p2.getProcessDefinitionUUID());
    }

    public void testMarketPlaceUndeployVersions() throws InterruptedException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        String item1 = Misc.getHumanReadableId((String)"item");
        int buyerPrice1 = Misc.random((int)0, (int)1000);
        int sellerPrice1 = Misc.random((int)-45, (int)1000);
        BuyerThread buyerThread1 = new BuyerThread(item1, buyerPrice1);
        SellerThread sellerThread1 = new SellerThread(item1, sellerPrice1);
        String item2 = Misc.getHumanReadableId((String)"item");
        int buyerPrice2 = Misc.random((int)0, (int)1000);
        int sellerPrice2 = Misc.random((int)-45, (int)1000);
        BuyerThread buyerThread2 = new BuyerThread(item2, buyerPrice2);
        SellerThread sellerThread2 = new SellerThread(item2, sellerPrice2);
        ProcessDefinition p1 = this.deployV1();
        buyerThread1.start();
        Thread.sleep(500L);
        ProcessDefinition p2 = this.deployV2();
        buyerThread2.start();
        Thread.sleep(500L);
        try {
            managementAPI.undeploy(p1.getProcessDefinitionUUID());
            Assert.fail((String)"exception expected");
        }
        catch (DeploymentException e) {
            // empty catch block
        }
        try {
            managementAPI.undeploy(p2.getProcessDefinitionUUID());
            Assert.fail((String)"exception expected");
        }
        catch (DeploymentException e) {
            // empty catch block
        }
        sellerThread1.start();
        try {
            while (!buyerThread1.ended || !sellerThread1.ended) {
                buyerThread1.join(1000L);
                sellerThread1.join(1000L);
                if (buyerThread1.exception != null) {
                    throw buyerThread1.exception;
                }
                if (sellerThread1.exception == null) continue;
                throw sellerThread1.exception;
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), (Throwable)e);
        }
        String success1 = "Deal OK";
        String fail1 = "Deal KO";
        this.checkResults(buyerPrice1, sellerPrice1, buyerThread1, sellerThread1, "Deal OK", "Deal KO");
        managementAPI.undeploy(p1.getProcessDefinitionUUID());
        try {
            managementAPI.undeploy(p2.getProcessDefinitionUUID());
            Assert.fail((String)"exception expected");
        }
        catch (DeploymentException e) {
            // empty catch block
        }
        sellerThread2.start();
        try {
            while (!buyerThread2.ended || !sellerThread2.ended) {
                buyerThread2.join(1000L);
                sellerThread2.join(1000L);
                if (buyerThread2.exception != null) {
                    throw buyerThread2.exception;
                }
                if (sellerThread2.exception == null) continue;
                throw sellerThread2.exception;
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), (Throwable)e);
        }
        String success2 = "Deal Successful";
        String fail2 = "Deal Failed";
        this.checkResults(buyerPrice2, sellerPrice2, buyerThread2, sellerThread2, "Deal Successful", "Deal Failed");
        managementAPI.undeploy(p2.getProcessDefinitionUUID());
    }

    private void checkResults(final int buyerPrice, final int sellerPrice, final BuyerThread buyerThread, final SellerThread sellerThread, final String successMsg, final String failMsg) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                BpelTestCase.CallResult buyerResult = buyerThread.callResult;
                BpelTestCase.CallResult sellerResult = sellerThread.callResult;
                MessageVariable buyerReply = buyerResult.getMessageCarrier().getMessage();
                MessageVariable sellerReply = sellerResult.getMessageCarrier().getMessage();
                if (buyerReply == null) {
                    throw new OrchestraRuntimeException("buyerReply is null");
                }
                if (sellerReply == null) {
                    throw new OrchestraRuntimeException("sellerReply is null");
                }
                Element buyerElement = buyerReply.getPartValue("outcome");
                if (buyerElement == null) {
                    throw new OrchestraRuntimeException("buyerReply.outcome is null");
                }
                Element sellerElement = sellerReply.getPartValue("outcome");
                if (sellerElement == null) {
                    throw new OrchestraRuntimeException("sellerReply.outcome is null");
                }
                String buyerOutcome = buyerElement.getTextContent();
                if (buyerOutcome == null) {
                    throw new OrchestraRuntimeException("buyerReply.outcome.textContent is null");
                }
                String sellerOutcome = sellerElement.getTextContent();
                if (sellerOutcome == null) {
                    throw new OrchestraRuntimeException("sellerReply.outcome.textContent is null");
                }
                MarketplaceVersioningTest.chekOutcomes(buyerPrice, buyerOutcome, sellerPrice, sellerOutcome, successMsg, failMsg);
                if (buyerResult.getProcessInstanceUUID() != null) {
                    MarketplaceVersioningTest.this.deleteInstance(buyerResult);
                } else {
                    MarketplaceVersioningTest.this.deleteInstance(sellerResult);
                }
                return null;
            }
        });
    }

    public static void chekOutcomes(int buyerPrice, String buyerOutcome, int sellerPrice, String sellerOutcome, String success, String fail) {
        if (buyerPrice >= sellerPrice) {
            if (!buyerOutcome.equals(success)) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and buyer outcome is not '" + success + "', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals(success)) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and seller outcome is not '" + success + "', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        } else {
            if (!buyerOutcome.equals(fail)) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and buyer outcome is not '" + fail + "', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals(fail)) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and seller outcome is not '" + fail + "', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SellerThread
    extends MPThread {
        public SellerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Element> getParts() {
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("inventoryItem", BpelXmlUtil.createElementWithContent((String)this.item));
            parts.put("askingPrice", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)));
            return parts;
        }

        @Override
        public String getOperationName() {
            return "seller";
        }

        @Override
        public QName getPortTypeQName() {
            return new QName(MarketplaceVersioningTest.this.getProcessNamespace(), "sellerPT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BuyerThread
    extends MPThread {
        public BuyerThread(String item, int price) {
            super(item, price);
        }

        @Override
        public HashMap<String, Element> getParts() {
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("item", BpelXmlUtil.createElementWithContent((String)this.item));
            parts.put("offer", BpelXmlUtil.createElementWithContent((String)Integer.toString(this.price)));
            return parts;
        }

        @Override
        public String getOperationName() {
            return "buyer";
        }

        @Override
        public QName getPortTypeQName() {
            return new QName(MarketplaceVersioningTest.this.getProcessNamespace(), "buyerPT");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class MPThread
    extends Thread {
        protected String item;
        protected int price;
        protected BpelTestCase.CallResult callResult;
        protected RuntimeException exception = null;
        protected boolean ended = false;

        public MPThread(String item, int price) {
            this.item = item;
            this.price = price;
        }

        public abstract HashMap<String, Element> getParts();

        public abstract String getOperationName();

        public abstract QName getPortTypeQName();

        @Override
        public void run() {
            try {
                this.callResult = MarketplaceVersioningTest.this.call(this.getParts(), this.getPortTypeQName(), this.getOperationName());
            }
            catch (RuntimeException e) {
                this.exception = e;
                throw e;
            }
            finally {
                this.ended = true;
            }
        }
    }
}

