/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chainer<T>
implements InvocationHandler {
    private static final Method TOSTRING_METHOD;
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private final List<T> chain = Collections.synchronizedList(new LinkedList());

    public void add(T element) {
        this.chain.add(element);
    }

    public void add(int i, T element) {
        this.chain.add(i, element);
    }

    public T remove(int i) {
        return this.chain.remove(i);
    }

    public T get(int i) {
        return this.chain.get(i);
    }

    public boolean contains(T element) {
        return this.chain.contains(element);
    }

    public List<T> getAsList() {
        return new LinkedList<T>(this.chain);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getReturnType().equals(Void.TYPE)) {
            for (T t : this.chain) {
                try {
                    method.invoke(t, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            return null;
        }
        if (method.equals(TOSTRING_METHOD)) {
            return "ChainerProxy: " + this.chain;
        }
        if (method.equals(HASHCODE_METHOD)) {
            return this.hashCode() + this.chain.hashCode();
        }
        if (method.equals(EQUALS_METHOD) && Proxy.isProxyClass(proxy.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
            return this.equals(invocationHandler);
        }
        throw new IllegalArgumentException("Only void method can be chained!");
    }

    static {
        Method tostringMethodTmp = null;
        Method equalsMethodTmp = null;
        Method hashcodeMethodTmp = null;
        try {
            tostringMethodTmp = Object.class.getMethod("toString", new Class[0]);
            equalsMethodTmp = Object.class.getMethod("equals", Object.class);
            hashcodeMethodTmp = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError("Ouch! Can't find Object method!");
        }
        TOSTRING_METHOD = tostringMethodTmp;
        EQUALS_METHOD = equalsMethodTmp;
        HASHCODE_METHOD = hashcodeMethodTmp;
    }
}

