/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.invoke;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.activities.invoke.InvokeTest;
import org.ow2.orchestra.test.wsutils.PersonWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class InvokeFromPartsTest
extends BpelTestCase {
    public InvokeFromPartsTest() {
        super("http://example.com/invoke", "invokeFromToParts");
    }

    public void testInvokeFromToParts() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        URL personsList = ((Object)((Object)this)).getClass().getResource("personsList.xml");
        this.assertExists(personsList);
        URL person = ((Object)((Object)this)).getClass().getResource("person.xml");
        this.assertExists(person);
        String personNS = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Document personFileDoc = XmlUtil.getDocumentFromURL((URL)person);
        String firstName = "myFirstName";
        Element firstNameElement = XmlUtil.getDocumentWithOneElement((QName)new QName(personNS, "firstName"));
        Text textContent = firstNameElement.getOwnerDocument().createTextNode("myFirstName");
        firstNameElement.appendChild(textContent);
        String lastName = "myLastName";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("personsList", XmlUtil.getDocumentFromURL((URL)personsList).getDocumentElement());
        parts.put("person", personFileDoc.getDocumentElement());
        parts.put("firstName", firstNameElement);
        parts.put("lastName", BpelXmlUtil.createElementWithContent((String)"myLastName"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "invokeFromToParts";
        WSRepository.addWS(PersonWS.PORTTYPE_QNAME, new PersonWS());
        BpelTestCase.CallResult result = this.call(parts, portTypeQName, "invokeFromToParts");
        MessageVariable reply = result.getMessageCarrier().getMessage();
        String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Assert.assertNotNull((Object)reply);
        Element listElement = reply.getPartValue("personsList");
        Assert.assertNotNull((Object)listElement);
        Assert.assertEquals((String)ns, (String)listElement.getNamespaceURI());
        Assert.assertEquals((String)"list", (String)listElement.getLocalName());
        List children = XmlUtil.elements((Element)listElement);
        Assert.assertEquals((int)2, (int)children.size());
        InvokeTest.assertPerson((Node)children.get(0), "Paul", "Glood", "21", "Jules Vernes", "75000", "Paris");
        InvokeTest.assertPerson((Node)children.get(1), "Roger", "Badin", "58", "Jean-Jacques ROUSSEAU", "13000", "Marseille");
        Element personElement = reply.getPartValue("person");
        InvokeTest.assertPerson(personElement, "Arthur", "Monulo", "5", "5 Avenue", "4444", "Los Angeles");
        Element firstNameEl = reply.getPartValue("firstName");
        Assert.assertEquals((String)personNS, (String)firstNameEl.getNamespaceURI());
        Assert.assertEquals((String)"firstName", (String)firstNameEl.getLocalName());
        Assert.assertEquals((int)0, (int)XmlUtil.elements((Element)firstNameEl).size());
        List<Text> firstNameChildren = BpelTestCase.getTexts(firstNameEl);
        Assert.assertEquals((int)1, (int)firstNameChildren.size());
        Text text = firstNameChildren.get(0);
        Assert.assertEquals((String)"myFirstName", (String)text.getTextContent());
        Element lastNameElement = reply.getPartValue("lastName");
        Assert.assertNotNull((Object)lastNameElement);
        Assert.assertEquals((String)"myLastName", (String)lastNameElement.getTextContent());
        this.deleteInstance(result);
        WSRepository.removeWS(PersonWS.PORTTYPE_QNAME);
        this.undeploy();
    }
}

