/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.fromAii;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class FromAiiTest
extends BpelTestCase {
    public FromAiiTest() {
        super("http://example.com/fromAii", "fromAii");
    }

    public void testFromAii() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public long launch() {
        URL baseProduct = ((Object)((Object)this)).getClass().getResource("baseProduct.xml");
        this.assertExists(baseProduct);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)baseProduct).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)13, (int)callResult.getVariables().size());
                FromAiiTest.this.assertProductAmount(FromAiiTest.this.getVariableValue(callResult, "productAmount1"));
                FromAiiTest.this.assertProductAmount(FromAiiTest.this.getVariableValue(callResult, "productAmount2"));
                FromAiiTest.this.assertProductReference(FromAiiTest.this.getVariableValue(callResult, "productReference1"));
                FromAiiTest.this.assertProductReference(FromAiiTest.this.getVariableValue(callResult, "productReference2"));
                FromAiiTest.this.assertBillingDetailVar(FromAiiTest.this.getVariableValue(callResult, "billingDetailVar"));
                FromAiiTest.this.assertProductQuantity(FromAiiTest.this.getVariableValue(callResult, "productQuantity1"));
                FromAiiTest.this.assertProductQuantity(FromAiiTest.this.getVariableValue(callResult, "productQuantity2"));
                FromAiiTest.this.assertProductName(FromAiiTest.this.getVariableValue(callResult, "productName1"));
                FromAiiTest.this.assertProductName(FromAiiTest.this.getVariableValue(callResult, "productName2"));
                FromAiiTest.this.assertBillingDetailVar2(FromAiiTest.this.getVariableValue(callResult, "billingDetailVar2"));
                FromAiiTest.this.assertProductQuantity(FromAiiTest.this.getVariableValue(callResult, "productQuantity3"));
                FromAiiTest.this.assertProductName(FromAiiTest.this.getVariableValue(callResult, "productName3"));
                FromAiiTest.this.assertBillingAmountVar(FromAiiTest.this.getVariableValue(callResult, "billingAmountVar"));
                FromAiiTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertProductAmount(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"123", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"", (String)root.getAttribute("reference"));
        Assert.assertNull((Object)root.getFirstChild());
    }

    private void assertProductReference(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"chips", (String)root.getAttribute("reference"));
        Assert.assertNull((Object)root.getFirstChild());
    }

    private void assertProductQuantity(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"", (String)root.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(root, "quantity", "123");
        this.assertElementNSContentAndNoChild(root, "name", "");
    }

    private void assertProductName(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"", (String)root.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(root, "quantity", "");
        this.assertElementNSContentAndNoChild(root, "name", "chips");
    }

    private void assertBillingDetailVar(Object o) {
        Element root = this.assertTopElementNS(o, "billingDetail");
        Assert.assertEquals((String)"2299", (String)root.getAttribute("amt"));
        this.assertNoElementChild(root);
    }

    private void assertBillingDetailVar2(Object o) {
        Element root = this.assertTopElementNS(o, "billingDetail");
        Assert.assertEquals((String)"8675309", (String)root.getAttribute("id"));
        Element billingAmount = this.assertElementNSContentAndNoChild(root, "billingAmount", "3399");
        Assert.assertEquals((String)"F00B2R", (String)billingAmount.getAttribute("code"));
    }

    private void assertBillingAmountVar(Object o) {
        Element root = this.assertTopElementNS(o, "billingAmount");
        Assert.assertEquals((String)"4499", (String)root.getTextContent());
        this.assertNoElementChild(root);
    }
}

