/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.exit;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class ExitWithFlowTest
extends BpelTestCase {
    public ExitWithFlowTest() {
        super("http://orchestra.ow2.org/exit", "exit", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testExitWithFlow() {
        this.deploy(((Object)((Object)this)).getClass().getResource("exit_with_flow.bpel"));
        this.launch();
        this.undeploy();
    }

    public void launch() {
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        long startTime = System.currentTimeMillis();
        long timeout = 180000L;
        boolean fail = true;
        while (startTime + 180000L > System.currentTimeMillis()) {
            if (((Boolean)commandService.execute((Command)new Command<Boolean>(){

                public Boolean execute(Environment environment) {
                    Set activityInstances = EnvTool.getQuerier().findActivityInstances(callResult.getProcessInstanceUUID(), ActivityState.RUNNING);
                    boolean foundResume = false;
                    for (ActivityFullInstance activity : activityInstances) {
                        ActivityFullDefinition activityDef = EnvTool.getQuerier().getActivityDefinition(activity.getDefinitionUUID());
                        foundResume |= "resume".equals(activityDef.getName());
                    }
                    return foundResume;
                }
            })).booleanValue()) {
                fail = false;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertFalse((String)"Timeout occured", (boolean)fail);
        this.call(parts, portTypeQName, "resume");
        this.deleteInstance(callResult);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }
}

