<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:pet="http://petals.ow2.org/SA"
  xmlns:sc="http://petals.ow2.org/SC" exclude-result-prefixes="pet"
  version="1.0" id="address">

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
    xml-declaration="yes" />

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="//*[local-name() = 'addresses']">
    <xsl:element name="sc:addresses">
      <xsl:for-each select="//*[local-name() = 'address']">
        <address>
          <xsl:if test="//*[local-name() = 'street']">
            <rue>
              <xsl:value-of select="//*[local-name() = 'street']" />
            </rue>
          </xsl:if>
          <xsl:if test="//*[local-name() = 'streetNumber']">
            <numero_rue>
              <xsl:value-of select="//*[local-name() = 'streetNumber']" />
            </numero_rue>
          </xsl:if>
          <xsl:if test="//*[local-name() = 'zipCode']">
            <code_postal>
              <xsl:value-of select="//*[local-name() = 'zipCode']" />
            </code_postal>
          </xsl:if>
          <xsl:if test="//*[local-name() = 'town']">
            <commune>
              <xsl:value-of select="//*[local-name() = 'town']" />
            </commune>
          </xsl:if>
          <xsl:if test="//*[local-name() = 'township']">
            <canton>
              <xsl:value-of select="//*[local-name() = 'township']" />
            </canton>
          </xsl:if>
          <xsl:if test="//*[local-name() = 'country']">
            <pays>
              <xsl:value-of select="//*[local-name() = 'country']" />
            </pays>
          </xsl:if>
        </address>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>






</xsl:stylesheet>