/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.invoke;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.activities.invoke.InvokeTest;
import org.ow2.orchestra.test.wsutils.PersonWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InvokeCreatePersonTest
extends BpelTestCase {
    public InvokeCreatePersonTest() {
        super("http://example.com/invoke", "invokePerson");
    }

    public void testInvokeCreatePerson() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String firstName = "myFirstName";
        String lastName = "myLastName";
        String age = "26";
        String street = "myStreet";
        String zip = "38130";
        String city = "myCity";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("firstName", BpelXmlUtil.createElementWithContent((String)"myFirstName"));
        parts.put("lastName", BpelXmlUtil.createElementWithContent((String)"myLastName"));
        parts.put("age", BpelXmlUtil.createElementWithContent((String)"26"));
        parts.put("street", BpelXmlUtil.createElementWithContent((String)"myStreet"));
        parts.put("zip", BpelXmlUtil.createElementWithContent((String)"38130"));
        parts.put("city", BpelXmlUtil.createElementWithContent((String)"myCity"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "invokePerson";
        WSRepository.addWS(PersonWS.PORTTYPE_QNAME, new PersonWS());
        BpelTestCase.CallResult result = this.call(parts, portTypeQName, "invokePerson");
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        MessageVariable reply = result.getMessageCarrier().getMessage();
        String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Assert.assertNotNull((Object)reply);
        Element personElement = reply.getPartValue("person");
        Assert.assertEquals((String)"createPerson", (String)personElement.getLocalName());
        Assert.assertEquals((String)ns, (String)personElement.getNamespaceURI());
        List children = XmlUtil.elements((Element)personElement);
        Assert.assertEquals((int)4, (int)children.size());
        InvokeTest.assertElement((Node)children.get(0), ns, "firstName", "myFirstName");
        InvokeTest.assertElement((Node)children.get(1), ns, "lastName", "myLastName");
        InvokeTest.assertElement((Node)children.get(2), ns, "age", "26");
        Assert.assertTrue((boolean)(children.get(3) instanceof Element));
        Element addressEl = (Element)children.get(3);
        List addressChildren = XmlUtil.elements((Element)addressEl);
        Assert.assertEquals((int)3, (int)addressChildren.size());
        InvokeTest.assertElement((Node)addressChildren.get(0), ns, "street", "myStreet");
        InvokeTest.assertElement((Node)addressChildren.get(1), ns, "zip", "38130");
        InvokeTest.assertElement((Node)addressChildren.get(2), ns, "city", "myCity");
        this.deleteInstance(result);
        WSRepository.removeWS(PersonWS.PORTTYPE_QNAME);
        this.undeploy();
    }
}

