/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.def;

import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ProcessStateUpdate;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.jmx.ManagementAPIImpl;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;

public abstract class AbstractProcessDefinitionVersioningTest
extends BpelTestCase {
    public abstract Querier getQuerier();

    public AbstractProcessDefinitionVersioningTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://orchestra.ow2.org/eventHandler", "eventHandler", environmentType);
    }

    public void testProcessDefinitionVersioning() throws ProcessNotFoundException {
        ProcessDefinition pd = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        managementAPI.retire(pd.getUUID());
        managementAPI.activate(pd.getUUID());
        managementAPI.undeploy(pd.getUUID());
        ProcessFullDefinition processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new GetProcessDefinitionCmd(pd));
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        Assert.assertEquals((Object)ProcessState.UNDEPLOYED, (Object)processFullDefinition.getState());
        Assert.assertEquals((int)4, (int)processFullDefinition.getStateUpdates().size());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(0)).getState());
        Assert.assertEquals((Object)ProcessState.RETIRED, (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(1)).getState());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(2)).getState());
        Assert.assertEquals((Object)ProcessState.UNDEPLOYED, (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(3)).getState());
        Assert.assertEquals((Object)processFullDefinition.getDeployedDate(), (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(0)).getDate());
        Assert.assertEquals((Object)processFullDefinition.getUndeployedDate(), (Object)((ProcessStateUpdate)processFullDefinition.getStateUpdates().get(3)).getDate());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class GetProcessDefinitionCmd
    implements Command<ProcessFullDefinition> {
        private final ProcessDefinition pd;

        protected GetProcessDefinitionCmd(ProcessDefinition pd) {
            this.pd = pd;
        }

        public ProcessFullDefinition execute(Environment environment) {
            Querier querier = AbstractProcessDefinitionVersioningTest.this.getQuerier();
            ProcessFullDefinition processFullDefinition = querier.getProcessDefinition(this.pd.getUUID());
            Assert.assertNotNull((Object)processFullDefinition);
            return processFullDefinition.fullCopy();
        }
    }
}

