/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.correlation.processCorrelation;

import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class ProcessOnEventTest
extends BpelTestCase {
    public ProcessOnEventTest() {
        super("http://example.com/onEvent", "onEvent", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testCorrelationOnProcessOnEvent() {
        this.deploy();
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        BpelTestCase.CallResult callResult1 = this.call(parts1, portTypeQName, "init");
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("id", BpelXmlUtil.createElementWithContent((String)"1"));
        BpelTestCase.CallResult callResult2 = this.call(parts2, portTypeQName, "init");
        this.waitForProcessInit(callResult1);
        this.waitForProcessInit(callResult2);
        this.call(parts1, portTypeQName, "incrInt1").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt2").getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "incrInt2").getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "incrInt1").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1").getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "incrInt2").getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "incrInt2").getMessageCarrier().getMessage();
        this.call(parts2, portTypeQName, "validate").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt1").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt2").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "validate").getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "incrInt2");
        this.call(parts2, portTypeQName, "incrInt1");
        this.call(parts2, portTypeQName, "incrInt2");
        MessageVariable reply1 = callResult1.getMessageCarrier().getMessage();
        MessageVariable reply2 = callResult2.getMessageCarrier().getMessage();
        int instance1int1 = Integer.parseInt(reply1.getPartValue("int1").getTextContent());
        int instance1int2 = Integer.parseInt(reply1.getPartValue("int2").getTextContent());
        int instance2int1 = Integer.parseInt(reply2.getPartValue("int1").getTextContent());
        int instance2int2 = Integer.parseInt(reply2.getPartValue("int2").getTextContent());
        Assert.assertEquals((int)4, (int)instance1int1);
        Assert.assertEquals((int)2, (int)instance1int2);
        Assert.assertEquals((int)1, (int)instance2int1);
        Assert.assertEquals((int)3, (int)instance2int2);
        this.deleteInstance(callResult1);
        this.deleteInstance(callResult2);
        this.undeploy();
    }

    private void waitForProcessInit(final BpelTestCase.CallResult callResult) {
        long startTime = System.currentTimeMillis();
        long timeout = 180000L;
        boolean fail = true;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        while (startTime + 180000L > System.currentTimeMillis()) {
            if (((Boolean)commandService.execute((Command)new Command<Boolean>(){

                public Boolean execute(Environment environment) {
                    Set activityInstances = EnvTool.getQuerier().findActivityInstances(callResult.getProcessInstanceUUID(), ActivityState.RUNNING);
                    boolean foundResume = false;
                    for (ActivityFullInstance activity : activityInstances) {
                        ActivityFullDefinition activityDef = EnvTool.getQuerier().getActivityDefinition(activity.getDefinitionUUID());
                        foundResume |= "validate".equals(activityDef.getName());
                    }
                    return foundResume;
                }
            })).booleanValue()) {
                fail = false;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertFalse((String)"Timeout occured", (boolean)fail);
    }
}

