/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.test.services.impl.ArchiveFinishedInstanceHandlerTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class RemoveInstanceTest
extends BpelTestCase {
    public RemoveInstanceTest() {
        super("http://orchestra.ow2.org/dfih", "archiveFIH", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testRemoveInstance() {
        this.deploy(ArchiveFinishedInstanceHandlerTest.class.getResource("archiveFIH.bpel"), ArchiveFinishedInstanceHandlerTest.class.getResource("dfih.wsdl"));
        this.launch();
        this.undeploy();
    }

    public void testRemoveInstanceBadArgs() {
        RemoteDeployerImpl api = new RemoteDeployerImpl(this.getEnvironmentFactory());
        try {
            api.remove((ProcessInstanceUUID)null);
            Assert.fail((String)"exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)api.remove(new ProcessInstanceUUID("Invalid UUID")));
    }

    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        envGenerator.setFinishedInstanceHandlerType(new Class[]{DeleteFinishedInstanceHandler.class, ArchiveFinishedInstanceHandler.class});
        return envGenerator;
    }

    public void launch() {
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("inv", BpelXmlUtil.createElementWithContent((String)"1"));
        QName portTypeQName = new QName(this.getProcessNamespace(), "dfihPT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts1, portTypeQName, "submit");
        RemoteDeployerImpl api = new RemoteDeployerImpl(this.getEnvironmentFactory());
        try {
            api.remove(callResult.getProcessInstanceUUID());
            Assert.fail((String)"Instance not finished and remove did not fail.");
        }
        catch (OrchestraRuntimeException e) {
            // empty catch block
        }
        this.call(parts1, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        try {
            Assert.assertNotNull((Object)api.getProcessInstance(callResult.getProcessInstanceUUID()));
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)"Instance not found");
        }
        Assert.assertTrue((boolean)api.remove(callResult.getProcessInstanceUUID()));
        try {
            api.getProcessInstance(callResult.getProcessInstanceUUID());
            Assert.fail((String)"Instance found");
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)api.remove(callResult.getProcessInstanceUUID()));
    }
}

