/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.test.services.impl.ArchiveFinishedInstanceHandlerTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class RemoveProcessTest
extends BpelTestCase {
    public RemoveProcessTest() {
        super("http://orchestra.ow2.org/dfih", "archiveFIH", BpelTestCase.EnvironmentType.CUSTOM);
    }

    public void testRemoveInstance() {
        RemoteDeployerImpl api = new RemoteDeployerImpl(this.getEnvironmentFactory());
        ProcessDefinitionUUID pduuid = this.deploy(ArchiveFinishedInstanceHandlerTest.class.getResource("archiveFIH.bpel"), ArchiveFinishedInstanceHandlerTest.class.getResource("dfih.wsdl")).getProcessDefinitionUUID();
        try {
            api.remove(pduuid);
            Assert.fail((String)"Process removed, but process still deployed.");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Please undeploy it first."));
        }
        ProcessInstanceUUID piuuid = this.launch();
        this.undeploy();
        try {
            api.remove(pduuid);
            Assert.fail((String)"Process removed, but there are still instances.");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Please remove instances first."));
        }
        Assert.assertTrue((boolean)api.remove(piuuid));
        try {
            Assert.assertNotNull((Object)api.getProcessDefinition(pduuid));
        }
        catch (ProcessNotFoundException e) {
            Assert.fail((String)"process not found");
        }
        Assert.assertTrue((boolean)api.remove(pduuid));
        try {
            api.getProcessDefinition(pduuid);
            Assert.fail((String)"process still found");
        }
        catch (ProcessNotFoundException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)api.remove(pduuid));
    }

    public void testRemoveInstanceBadArgs() {
        RemoteDeployerImpl api = new RemoteDeployerImpl(this.getEnvironmentFactory());
        try {
            api.remove((ProcessDefinitionUUID)null);
            Assert.fail((String)"exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)api.remove(new ProcessDefinitionUUID("Invalid UUID")));
    }

    public DefaultEnvXMLGenerator getCustomEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_WITH_HISTORY);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        envGenerator.setFinishedInstanceHandlerType(new Class[]{DeleteFinishedInstanceHandler.class, ArchiveFinishedInstanceHandler.class});
        return envGenerator;
    }

    public ProcessInstanceUUID launch() {
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("inv", BpelXmlUtil.createElementWithContent((String)"1"));
        QName portTypeQName = new QName(this.getProcessNamespace(), "dfihPT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts1, portTypeQName, "submit");
        this.call(parts1, portTypeQName, "continue");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        return callResult.getProcessInstanceUUID();
    }
}

