/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.versioning;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EndpointVersioningTest
extends RemoteTestCase {
    private final String processName = "helloworld";
    private final String processNamespace = "http://example.com/helloworld";

    public void testHelloworldDifferentEndpoint() throws SOAPException {
        String endpointV1 = this.getDefaultEndpoint("helloworld/v1/helloworldPort");
        String endpointV2 = this.getDefaultEndpoint("helloworld/v2/helloworldPort");
        ProcessDefinition pd1 = this.deploy(this.processName + "-v1-endpoint");
        this.launchProcessInstance(endpointV1, "Toto", "Toto");
        ProcessDefinition pd2 = this.deploy(this.processName + "-v2-endpoint");
        this.launchProcessInstance(endpointV1, "Toto", "Toto");
        this.launchProcessInstance(endpointV2, "Toto", "hello Toto");
        this.undeploy(pd2.getUUID());
        this.launchProcessInstance(endpointV1, "Toto", "Toto");
        try {
            this.launchProcessInstance(endpointV2, "Toto", "hello Toto");
            Assert.fail((String)"Service should be unavailable");
        }
        catch (RuntimeException e) {
        }
        catch (ComparisonFailure e) {
            // empty catch block
        }
        ProcessDefinition pd3 = this.deploy(this.processName + "-v2-endpoint");
        this.launchProcessInstance(endpointV1, "Toto", "Toto");
        this.launchProcessInstance(endpointV2, "Toto", "hello Toto");
        this.undeploy(pd1.getUUID());
        try {
            this.launchProcessInstance(endpointV1, "Toto", "Toto");
            Assert.fail((String)"Service should be unavailable");
        }
        catch (RuntimeException e) {
        }
        catch (ComparisonFailure e) {
            // empty catch block
        }
        this.launchProcessInstance(endpointV2, "Toto", "hello Toto");
        this.undeploy(pd3.getUUID());
        try {
            this.launchProcessInstance(endpointV1, "Toto", "Toto");
            Assert.fail((String)"Service should be unavailable");
        }
        catch (RuntimeException e) {
        }
        catch (ComparisonFailure e) {
            // empty catch block
        }
        try {
            this.launchProcessInstance(endpointV2, "Toto", "hello Toto");
            Assert.fail((String)"Service should be unavailable");
        }
        catch (RuntimeException e) {
        }
        catch (ComparisonFailure e) {
            // empty catch block
        }
    }

    private void launchProcessInstance(String endpoint, String input, String expectedOutput) throws SOAPException {
        String part = "<submit xmlns='http://example.com/helloworld'><st>" + input + "</st></submit>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/helloworld/submit", (String)part);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
        if (response != null) {
            SOAPBodyElement result = this.getSOAPBodyElement(response);
            this.checkReturn(result, expectedOutput);
        } else {
            Assert.assertTrue((String)"No return available", (boolean)false);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"submit", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.processNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Element st = XmlUtil.element((Element)result);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.processNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

