/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.hibernate.Session;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.EnvFactoryRepository;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeTestCase
extends TestCase {
    public <C> void verifyPersistence(Class<C> clazz) throws Exception {
        HashSet<String> classNameCreated = new HashSet<String>();
        C c1 = this.createNotDefaultObject(clazz, classNameCreated);
        classNameCreated.clear();
        C c2 = this.createSecondObject(clazz, classNameCreated);
        classNameCreated.clear();
        C pc1 = this.persistAndRestore(c1);
        C pc2 = this.persistAndRestore(c2);
        this.verifyObject(clazz, c1, pc1, classNameCreated);
        classNameCreated.clear();
        this.verifyObject(clazz, c2, pc2, classNameCreated);
        classNameCreated.clear();
    }

    public boolean shouldExclude(String className, String fieldName) {
        if (fieldName.equals("dbid") || fieldName.equals("dbversion")) {
            return true;
        }
        return className.equals(Throwable.class.getName());
    }

    public Object createCustomReference(String className, String fieldName) {
        return null;
    }

    private synchronized EnvironmentFactory getEnvironmentFactory() {
        if (EnvFactoryRepository.get() == null) {
            try {
                DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator();
                envGenerator.setApplicationEntry("serviceInvoker", TestInvoker.class);
                envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
                EnvFactoryRepository.set(envGenerator.createEnvironmentFactory());
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
        return EnvFactoryRepository.get();
    }

    private <C> C createNotDefaultObject(Class<C> clazz, Set<String> classNameCreated) throws Exception {
        C instance;
        Constructor<C> constructor;
        boolean alreadyCreated = false;
        if (classNameCreated.contains(clazz.getName())) {
            alreadyCreated = true;
        } else {
            classNameCreated.add(clazz.getName());
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (clazz.equals(Class.class)) {
                System.out.println("Cant use constructor for java.lang.Class");
                return null;
            }
        }
        catch (NoSuchMethodException e) {
            System.out.println("No constructor for " + clazz.getName());
            return null;
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
            instance = constructor.newInstance(new Object[0]);
            constructor.setAccessible(false);
        } else {
            instance = constructor.newInstance(new Object[0]);
        }
        for (Class<C> currentClass = clazz; currentClass != null && !Object.class.equals(currentClass); currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                Class<?> type;
                int modifier;
                if (this.shouldExclude(currentClass.getName(), field.getName()) || Modifier.isStatic(modifier = field.getModifiers()) || Modifier.isTransient(modifier)) continue;
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                if ((type = field.getType()).equals(Integer.TYPE)) {
                    field.setInt(instance, 1);
                } else if (type.equals(Boolean.TYPE)) {
                    field.setBoolean(instance, true);
                } else if (type.equals(Short.TYPE)) {
                    field.setShort(instance, (short)1);
                } else if (type.equals(Long.TYPE)) {
                    field.setLong(instance, 1L);
                } else if (type.equals(Double.TYPE)) {
                    field.setDouble(instance, 1.0);
                } else if (type.equals(Float.TYPE)) {
                    field.setFloat(instance, 1.0f);
                } else if (type.equals(Byte.TYPE)) {
                    field.setByte(instance, (byte)1);
                } else if (type.equals(Character.TYPE)) {
                    field.setChar(instance, '\u0001');
                } else if (type.equals(String.class)) {
                    field.set(instance, "1");
                } else if (!alreadyCreated) {
                    String fieldName = field.getName();
                    Object customReference = this.createCustomReference(currentClass.getName(), fieldName);
                    if (customReference == null) {
                        field.set(instance, this.createNotDefaultObject(type, classNameCreated));
                    } else {
                        field.set(instance, customReference);
                    }
                }
                if (accessible) continue;
                field.setAccessible(false);
            }
        }
        return instance;
    }

    private <C> C createSecondObject(Class<C> clazz, Set<String> classNameCreated) throws Exception {
        C instance;
        Constructor<C> constructor;
        boolean alreadyCreated = false;
        if (classNameCreated.contains(clazz.getName())) {
            alreadyCreated = true;
        } else {
            classNameCreated.add(clazz.getName());
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (clazz.equals(Class.class)) {
                System.out.println("Cant use constructor for java.lang.Class");
                return null;
            }
        }
        catch (NoSuchMethodException e) {
            System.out.println("No constructor for " + clazz.getName());
            return null;
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
            instance = constructor.newInstance(new Object[0]);
            constructor.setAccessible(false);
        } else {
            instance = constructor.newInstance(new Object[0]);
        }
        for (Class<C> currentClass = clazz; currentClass != null && !Object.class.equals(currentClass); currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                Class<?> type;
                int modifier;
                if (this.shouldExclude(currentClass.getName(), field.getName()) || Modifier.isStatic(modifier = field.getModifiers()) || Modifier.isTransient(modifier)) continue;
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                if ((type = field.getType()).equals(Integer.TYPE)) {
                    field.setInt(instance, 2);
                } else if (type.equals(Boolean.TYPE)) {
                    field.setBoolean(instance, false);
                } else if (type.equals(Short.TYPE)) {
                    field.setShort(instance, (short)2);
                } else if (type.equals(Long.TYPE)) {
                    field.setLong(instance, 2L);
                } else if (type.equals(Double.TYPE)) {
                    field.setDouble(instance, 2.0);
                } else if (type.equals(Float.TYPE)) {
                    field.setFloat(instance, 2.0f);
                } else if (type.equals(Byte.TYPE)) {
                    field.setByte(instance, (byte)2);
                } else if (type.equals(Character.TYPE)) {
                    field.setChar(instance, '\u0002');
                } else if (type.equals(String.class)) {
                    field.set(instance, "foo");
                } else if (!alreadyCreated) {
                    String fieldName = field.getName();
                    Object customReference = this.createCustomReference(currentClass.getName(), fieldName);
                    if (customReference == null) {
                        field.set(instance, this.createNotDefaultObject(type, classNameCreated));
                    } else {
                        field.set(instance, customReference);
                    }
                }
                if (accessible) continue;
                field.setAccessible(false);
            }
        }
        return instance;
    }

    private <C> C persistAndRestore(final C instance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        final Serializable id = (Serializable)commandService.execute((Command)new Command<Serializable>(){

            public Serializable execute(Environment environment) {
                Session session = (Session)environment.get("hibernate-session:core");
                return session.save(instance);
            }
        });
        return (C)commandService.execute(new Command<C>(){

            public C execute(Environment environment) {
                Session session = (Session)environment.get("hibernate-session:core");
                Object restoredInstance = session.get(instance.getClass(), id);
                session.delete(restoredInstance);
                return restoredInstance;
            }
        });
    }

    public void persist(final Object ... instances) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                Session session = (Session)environment.get("hibernate-session:core");
                for (Object instance : instances) {
                    session.save(instance);
                }
                session.flush();
                return null;
            }
        });
    }

    public void delete(final Object ... instances) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                Session session = (Session)environment.get("hibernate-session:core");
                for (Object instance : instances) {
                    session.delete(instance);
                }
                return null;
            }
        });
    }

    private <C> void verifySubObject(Class<C> clazz, Field field, Object originalInstance, Object instance, Set<String> classNameCreated) throws Exception {
        C originalFieldValue = clazz.cast(field.get(originalInstance));
        C fieldValue = clazz.cast(field.get(instance));
        if (originalFieldValue == null) {
            if (fieldValue != null) {
                Assert.fail((String)(clazz.getName() + " not persisted in field [" + field + "] was null before, override createCustomReference method to create this object"));
            }
        } else if (fieldValue == null) {
            Assert.fail((String)(clazz.getName() + " not persisted in field [" + field + "] becomes null after, verify your persistance manager configuration"));
        } else {
            this.verifyObject(clazz, originalFieldValue, fieldValue, classNameCreated);
        }
    }

    private <C> void verifyObject(Class<C> clazz, C originalInstance, C instance, Set<String> classNameCreated) throws Exception {
        if (classNameCreated.contains(clazz.getName())) {
            return;
        }
        classNameCreated.add(clazz.getName());
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<C> currentClass = clazz; currentClass != null && !Object.class.equals(currentClass); currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (this.shouldExclude(currentClass.getName(), field.getName())) continue;
                fieldList.add(field);
            }
        }
        for (Field field : fieldList) {
            Class<?> type;
            int modifier = field.getModifiers();
            if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) continue;
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            if ((type = field.getType()).equals(Integer.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (int)field.getInt(originalInstance), (int)field.getInt(instance));
            } else if (type.equals(Boolean.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (boolean)field.getBoolean(originalInstance), (boolean)field.getBoolean(instance));
            } else if (type.equals(Short.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (short)field.getShort(originalInstance), (short)field.getShort(instance));
            } else if (type.equals(Long.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (long)field.getLong(originalInstance), (long)field.getLong(instance));
            } else if (type.equals(Double.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (Object)field.getDouble(originalInstance), (Object)field.getDouble(instance));
            } else if (type.equals(Float.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (Object)Float.valueOf(field.getFloat(originalInstance)), (Object)Float.valueOf(field.getFloat(instance)));
            } else if (type.equals(Byte.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (byte)field.getByte(originalInstance), (byte)field.getByte(instance));
            } else if (type.equals(Character.TYPE)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (char)field.getChar(originalInstance), (char)field.getChar(instance));
            } else if (type.equals(String.class)) {
                Assert.assertEquals((String)(type.getName() + " not persisted in field [" + field + "]"), (Object)field.get(originalInstance), (Object)field.get(instance));
            } else {
                this.verifySubObject(type, field, originalInstance, instance, classNameCreated);
            }
            if (accessible) continue;
            field.setAccessible(false);
        }
    }
}

