/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GossipData
implements Streamable {
    byte type = 0;
    String group = null;
    Address addr = null;
    String logical_name = null;
    List<Address> mbrs = null;
    Collection<PhysicalAddress> physical_addrs = null;
    byte[] buffer = null;
    int offset = 0;
    int length = 0;

    public GossipData() {
    }

    public GossipData(byte type) {
        this.type = type;
    }

    public GossipData(byte type, String group, Address addr) {
        this(type);
        this.group = group;
        this.addr = addr;
    }

    public GossipData(byte type, String group, Address addr, List<Address> mbrs) {
        this(type, group, addr);
        this.mbrs = mbrs;
    }

    public GossipData(byte type, String group, Address addr, List<Address> mbrs, List<PhysicalAddress> physical_addrs) {
        this(type, group, addr, mbrs);
        this.physical_addrs = physical_addrs;
    }

    public GossipData(byte type, String group, Address addr, String logical_name, List<PhysicalAddress> phys_addrs) {
        this(type, group, addr);
        this.logical_name = logical_name;
        this.physical_addrs = phys_addrs;
    }

    public GossipData(byte type, String group, Address addr, byte[] buffer) {
        this(type, group, addr, buffer, 0, buffer.length);
    }

    public GossipData(byte type, String group, Address addr, byte[] buffer, int offset, int length) {
        this(type, group, addr);
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public byte getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public Address getAddress() {
        return this.addr;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public List<Address> getMembers() {
        return this.mbrs;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public Collection<PhysicalAddress> getPhysicalAddresses() {
        return this.physical_addrs;
    }

    public void setMembers(List<Address> mbrs) {
        this.mbrs = mbrs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GossipRouter.type2String(this.type)).append("(").append("group=").append(this.group).append(", addr=").append(this.addr);
        if (this.logical_name != null) {
            sb.append(", logical_name=" + this.logical_name);
        }
        if (this.mbrs != null && !this.mbrs.isEmpty()) {
            sb.append(", mbrs=").append(this.mbrs);
        }
        if (this.physical_addrs != null && !this.physical_addrs.isEmpty()) {
            sb.append(", physical_addrs=").append(Util.printListWithDelimiter(this.physical_addrs, ", "));
        }
        if (this.buffer != null) {
            sb.append(", buffer: " + this.length + " bytes");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        Util.writeString(this.group, out);
        Util.writeAddress(this.addr, out);
        Util.writeString(this.logical_name, out);
        Util.writeAddresses(this.mbrs, out);
        Util.writeAddresses(this.physical_addrs, out);
        Util.writeByteBuffer(this.buffer, this.offset, this.length, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.type = in.readByte();
        this.group = Util.readString(in);
        this.addr = Util.readAddress(in);
        this.logical_name = Util.readString(in);
        this.mbrs = (List)Util.readAddresses(in, LinkedList.class);
        this.physical_addrs = Util.readAddresses(in, ArrayList.class);
        this.buffer = Util.readByteBuffer(in);
        if (this.buffer != null) {
            this.offset = 0;
            this.length = this.buffer.length;
        }
    }

    public int size() {
        int retval = 1;
        retval += 3;
        if (this.group != null) {
            retval += this.group.length() + 2;
        }
        retval += Util.size(this.addr);
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval = (int)((long)retval + Util.size(this.mbrs));
        retval = (int)((long)retval + Util.size(this.physical_addrs));
        if (this.buffer != null) {
            retval += 4 + this.length;
        }
        return retval;
    }
}

