/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileOutputStream;
import org.jgroups.blocks.GridInputStream;
import org.jgroups.blocks.ReplCache;
import org.jgroups.util.Util;

public class GridInputStreamTest {
    public static void main(String[] args) throws Exception {
        int bytes_read;
        String props = "udp.xml";
        String cluster_name = "imfs-cluster";
        String input_file = "/home/bela/tmp2.txt";
        String output_file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-cluster_name")) {
                cluster_name = args[++i];
                continue;
            }
            if (args[i].equals("-output_file")) {
                output_file = args[++i];
                continue;
            }
            if (args[i].equals("-input_file")) {
                input_file = args[++i];
                continue;
            }
            System.out.println("GridInputStreamTest [-props <JGroups config>] [-cluster_name <cluster name] [-input_file <file to read from cluster>][-output_file <path to file to write to file system>]");
            return;
        }
        ReplCache<String, byte[]> cache = new ReplCache<String, byte[]>(props, cluster_name);
        cache.start();
        GridInputStream input = new GridInputStream(input_file, cache, 8000);
        FileOutputStream out = output_file != null ? new FileOutputStream(output_file) : null;
        byte[] buf = new byte[50000];
        int total_bytes = 0;
        long start = System.currentTimeMillis();
        while ((bytes_read = input.read(buf, 0, buf.length)) != -1) {
            if (out != null) {
                out.write(buf, 0, bytes_read);
            }
            total_bytes += bytes_read;
        }
        long diff = System.currentTimeMillis() - start;
        Util.close(input);
        Util.close(out);
        cache.stop();
        double throughput = (double)total_bytes / ((double)diff / 1000.0);
        System.out.println("read " + Util.printBytes(total_bytes) + " bytes in " + diff + " ms, " + "throughput=" + Util.printBytes(throughput) + " / sec");
    }
}

